/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.itemhandler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.screen.slots.SlotPriorityPredicates;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CommonChemiItemHandler
implements IItemHandler {
    private final ItemStackHandler handler;
    private final List<SlotPriorityRule> rules;
    private final List<Integer> outputs;

    private CommonChemiItemHandler(ItemStackHandler h, List<SlotPriorityRule> r, List<Integer> o) {
        this.handler = h;
        this.rules = r;
        this.outputs = o;
    }

    public int getSlots() {
        return 2;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            return this.extractItem(0, 64, true);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack remainedStack = stack.m_41777_();
        HashSet<Integer> ruledSlots = new HashSet<Integer>();
        for (SlotPriorityRule rule : this.rules) {
            int i;
            int slotstart = rule.startSlot();
            int slotend = rule.endSlot();
            for (i = slotstart; i < slotend; ++i) {
                ruledSlots.add(i);
            }
            if (!rule.matcher().test(stack)) continue;
            for (i = slotstart; i < slotend; ++i) {
                if (!(remainedStack = this.handler.insertItem(i, remainedStack, simulate)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        for (int i = 0; i < this.handler.getSlots() && (ruledSlots.contains(i) || !(remainedStack = this.handler.insertItem(i, remainedStack, simulate)).m_41619_()); ++i) {
        }
        return remainedStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        for (int outslot : this.outputs) {
            if (this.handler.getStackInSlot(outslot).m_41619_()) continue;
            return this.handler.extractItem(outslot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    public static class Builder {
        private final ItemStackHandler internalhandler;
        private final List<SlotPriorityRule> internalrules = new ArrayList<SlotPriorityRule>();
        private final List<Integer> internaloutputs = new ArrayList<Integer>();

        private Builder(ItemStackHandler handler) {
            this.internalhandler = handler;
        }

        public static Builder of(ItemStackHandler handler) {
            return new Builder(handler);
        }

        public Builder fuelslot(int i) {
            this.internalrules.add(SlotPriorityRule.single(SlotPriorityPredicates.IsFuel, i));
            return this;
        }

        public Builder anyfluidInputslot(int i) {
            this.internalrules.add(SlotPriorityRule.single(SlotPriorityPredicates.IsFluidContainer, i));
            return this;
        }

        public Builder anyfluidOutputslot(int i) {
            this.internalrules.add(SlotPriorityRule.single(SlotPriorityPredicates.IsFluidcase, i));
            return this;
        }

        public Builder specificFluidInputSlot(Fluid fluid, int i) {
            this.internalrules.add(SlotPriorityRule.single(stack -> FluidItemConverter.getFluidstackFromItem(stack).getFluid() == fluid, i));
            return this;
        }

        public Builder customInputRule(SlotPriorityRule rule) {
            this.internalrules.add(rule);
            return this;
        }

        public Builder outputslot(int ... slots) {
            for (int i : slots) {
                this.internaloutputs.add(i);
            }
            return this;
        }

        public CommonChemiItemHandler build() {
            return new CommonChemiItemHandler(this.internalhandler, this.internalrules, this.internaloutputs);
        }
    }
}

