/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.lamp;

import kandango.reagenica.block.entity.lamp.LampStates;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.packet.SyncLampState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public class LampControllerHelper<T extends BlockEntity> {
    private final T be;
    private LampStates lamp = LampStates.OFF;
    private int ticker = 0;

    public LampControllerHelper(T be) {
        this.be = be;
    }

    public LampStates getLampStates() {
        return this.lamp;
    }

    public boolean changeLampState(LampStates states) {
        if (!states.equals(this.lamp)) {
            this.lamp = states;
            boolean sent = this.syncLampToClient();
            if (!sent) {
                this.lamp = LampStates.WARN;
            }
            return true;
        }
        return false;
    }

    public boolean syncLampToClient() {
        Level lv = this.be.m_58904_();
        BlockPos pos = this.be.m_58899_();
        if (lv != null && !lv.f_46443_) {
            ModMessages.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> lv.m_46745_(pos)), (Object)new SyncLampState(pos, this.lamp));
            return true;
        }
        return lv != null;
    }

    public void lampSyncer() {
        ++this.ticker;
        if (this.ticker >= 60) {
            this.ticker = 0;
            this.syncLampToClient();
        }
    }

    public void receivePacket(LampStates states) {
        this.lamp = states;
    }
}

