/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.lamp;

import kandango.reagenica.block.entity.lamp.LampState;

public record LampStates(LampState red, LampState yellow, LampState green) {
    public static final LampStates OFF = new LampStates(LampState.OFF, LampState.OFF, LampState.OFF);
    public static final LampStates GREEN = new LampStates(LampState.OFF, LampState.OFF, LampState.ON);
    public static final LampStates YELLOW = new LampStates(LampState.OFF, LampState.ON, LampState.OFF);
    public static final LampStates RED = new LampStates(LampState.ON, LampState.OFF, LampState.OFF);
    public static final LampStates EMERG = new LampStates(LampState.BLINK, LampState.OFF, LampState.OFF);
    public static final LampStates WARN = new LampStates(LampState.OFF, LampState.BLINK, LampState.OFF);
    public static final LampStates SLOW = new LampStates(LampState.OFF, LampState.ON, LampState.ON);
    public static final LampStates BOOTING = new LampStates(LampState.OFF, LampState.OFF, LampState.BLINK);

    public LampState getLampState(int layer) {
        if (layer == 0) {
            return this.green;
        }
        if (layer == 1) {
            return this.yellow;
        }
        if (layer == 2) {
            return this.red;
        }
        throw new IndexOutOfBoundsException();
    }

    public int toInt() {
        return this.sti(this.green) | this.sti(this.yellow) << 8 | this.sti(this.red) << 16;
    }

    public static LampStates fromInt(int id) {
        return new LampStates(LampStates.its(id >> 16 & 0xF), LampStates.its(id >> 8 & 0xF), LampStates.its(id & 0xF));
    }

    private int sti(LampState s) {
        if (s == LampState.OFF) {
            return 0;
        }
        if (s == LampState.BLINK) {
            return 1;
        }
        return 2;
    }

    private static LampState its(int i) {
        if (i == 0) {
            return LampState.OFF;
        }
        if (i == 1) {
            return LampState.BLINK;
        }
        return LampState.ON;
    }
}

