/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.util;

import kandango.reagenica.ChemiItems;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.item.FluidJar;
import kandango.reagenica.item.reagent.Reagent;
import kandango.reagenica.item.reagent.ReagentFluidMap;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class FluidItemConverter {
    private static final int TESTTUBE_VOLUME = 100;

    public static ItemStack getItemstackFromFluid(FluidStack fluid, ItemStack in) {
        if (in.m_41720_() == Items.f_42446_) {
            if (fluid.getAmount() < 1000) {
                return ItemStack.f_41583_;
            }
            return FluidUtil.getFilledBucket((FluidStack)fluid);
        }
        if (in.m_41720_() == ChemiItems.TESTTUBE.get()) {
            if (fluid.getAmount() < 100) {
                return ItemStack.f_41583_;
            }
            return ReagentFluidMap.getItemfromFluid(fluid.getFluid()).map(item -> new ItemStack((ItemLike)item)).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public static FluidStack getFluidstackFromItem(ItemStack item) {
        if (item.m_41720_() == ChemiItems.FLUIDJAR.get()) {
            return FluidJar.getFluidStack(item);
        }
        return FluidUtil.getFluidContained((ItemStack)item).orElseGet(() -> ReagentFluidMap.getFluidfromItem(item.m_41720_()).map(fluid -> new FluidStack(fluid, 100)).orElse(FluidStack.EMPTY));
    }

    public static ItemStack drainToItemFromTank(FluidTank tank, ItemStack in) {
        ItemStack item = FluidItemConverter.getItemstackFromFluid(tank.getFluid(), in);
        if (!item.m_41619_()) {
            if (in.m_41720_() == Items.f_42446_) {
                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            } else if (in.m_41720_() == ChemiItems.TESTTUBE.get()) {
                tank.drain(100, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return item;
    }

    public static boolean draintoItem(ItemStackHandler handler, int inputindex, int outputindex, FluidTank tank) {
        ItemStack inslot = handler.getStackInSlot(inputindex);
        ItemStack outslot = handler.getStackInSlot(outputindex);
        if (inslot.m_41720_() == ChemiItems.MINEWIPE.get()) {
            if (!tank.isEmpty() && tank.getFluidAmount() < 100) {
                tank.drain(tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                handler.getStackInSlot(inputindex).m_41774_(1);
                return true;
            }
            return false;
        }
        ItemStack item = FluidItemConverter.getItemstackFromFluid(tank.getFluid(), inslot);
        if (!item.m_41619_() && ItemStackUtil.canAddStack(outslot, item)) {
            FluidItemConverter.drainToItemFromTank(tank, inslot);
            handler.setStackInSlot(outputindex, ItemStackUtil.addStack(outslot, item));
            handler.getStackInSlot(inputindex).m_41774_(1);
            return true;
        }
        return false;
    }

    public static boolean draintoItem(ItemStackHandler handler, int inputindex, FluidTank tank) {
        return FluidItemConverter.draintoItem(handler, inputindex, inputindex + 1, tank);
    }

    public static boolean drainfromItem(ItemStackHandler handler, int inputindex, int outputindex, FluidTank tank) {
        ItemStack inslot = handler.getStackInSlot(inputindex);
        ItemStack outslot = handler.getStackInSlot(outputindex);
        FluidStack fluid = FluidItemConverter.getFluidstackFromItem(inslot);
        if (inslot.m_41720_() instanceof Reagent && !fluid.isEmpty()) {
            int draining = tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
            if (draining == 100 && ItemStackUtil.canAddStack(outslot.m_41777_(), new ItemStack((ItemLike)ChemiItems.TESTTUBE.get(), 1))) {
                tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                inslot.m_41774_(1);
                handler.setStackInSlot(outputindex, ItemStackUtil.addStack(outslot.m_41777_(), new ItemStack((ItemLike)ChemiItems.TESTTUBE.get(), 1)));
                return true;
            }
        } else if (!fluid.isEmpty()) {
            if (inslot.m_41720_() instanceof BucketItem) {
                int draining = tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                if (draining == 1000 && ItemStackUtil.canAddStack(outslot, new ItemStack((ItemLike)Items.f_42446_))) {
                    tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    inslot.m_41774_(1);
                    handler.setStackInSlot(outputindex, ItemStackUtil.addStack(outslot.m_41777_(), new ItemStack((ItemLike)Items.f_42446_)));
                    return true;
                }
            } else if (inslot.m_41720_() == ChemiItems.FLUIDJAR.get() && FluidStackUtil.canFullyInsertToTank(fluid, tank)) {
                tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                inslot.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    public static boolean drainfromItem(ItemStackHandler handler, int inputindex, FluidTank tank) {
        return FluidItemConverter.drainfromItem(handler, inputindex, inputindex + 1, tank);
    }
}

