/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.entity.util;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackUtil {
    public static boolean canAddStack(ItemStack origin, ItemStack insert) {
        if (insert.m_41619_() || origin.m_41619_()) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)origin, (ItemStack)insert) && origin.m_41613_() + insert.m_41613_() <= origin.m_41741_();
    }

    public static int canAddStackPartially(ItemStack origin, ItemStack insert) {
        if (insert.m_41619_()) {
            return 0;
        }
        if (origin.m_41619_()) {
            return insert.m_41613_();
        }
        if (!ItemStack.m_150942_((ItemStack)origin, (ItemStack)insert)) {
            return 0;
        }
        int maxstack = origin.m_41741_();
        int origincount = origin.m_41613_();
        int insertcount = insert.m_41613_();
        return Math.min(maxstack - origincount, insertcount);
    }

    public static ItemStack addStack(ItemStack original, ItemStack inserting) {
        ItemStack insert;
        ItemStack origin = original.m_41777_();
        if (!ItemStackUtil.canAddStack(origin, insert = inserting.m_41777_())) {
            throw new IllegalArgumentException("Could not merge items");
        }
        if (origin.m_41619_()) {
            return insert;
        }
        if (insert.m_41619_()) {
            return origin;
        }
        origin.m_41769_(insert.m_41613_());
        return origin;
    }

    public static void addStackToSlot(ItemStackHandler handler, int slot, ItemStack stack) {
        ItemStack merged = ItemStackUtil.addStack(handler.getStackInSlot(slot), stack);
        handler.setStackInSlot(slot, merged);
    }

    public static boolean addStackToSlotifPossible(ItemStackHandler handler, int slot, ItemStack stack) {
        ItemStack stackinhandler = handler.getStackInSlot(slot);
        if (ItemStackUtil.canAddStack(stackinhandler, stack)) {
            ItemStack merged = ItemStackUtil.addStack(stackinhandler, stack);
            handler.setStackInSlot(slot, merged);
            return true;
        }
        return false;
    }

    public static ItemStack addStackToSlotAsMuchAsPossible(ItemStackHandler handler, int slot, ItemStack stack) {
        ItemStack stackinhandler = handler.getStackInSlot(slot);
        int addstack = ItemStackUtil.canAddStackPartially(stackinhandler, stack);
        if (addstack > 0) {
            if (ItemStackUtil.canAddStack(stackinhandler, stack)) {
                ItemStackUtil.addStackToSlot(handler, slot, stack);
                return ItemStack.f_41583_;
            }
            ItemStack merged = stackinhandler.m_41777_();
            merged.m_41764_(stackinhandler.m_41741_());
            handler.setStackInSlot(slot, merged);
            ItemStack residual = stack.m_41777_();
            residual.m_41774_(addstack);
            return residual;
        }
        return stack;
    }

    public static int getFuelExceptforLava(ItemStack itemstack) {
        int burn = ForgeHooks.getBurnTime((ItemStack)itemstack, (RecipeType)RecipeType.f_44108_);
        if (itemstack.m_41720_() == Items.f_42448_) {
            burn = 0;
        }
        return burn;
    }

    public static boolean isEnough(ItemStack is, ItemStack cost) {
        if (cost.m_41619_()) {
            return true;
        }
        if (is.m_41619_()) {
            return false;
        }
        if (ItemStack.m_150942_((ItemStack)is, (ItemStack)cost)) {
            return is.m_41613_() >= cost.m_41613_();
        }
        return false;
    }

    public static void drop(@Nonnull Level lv, BlockPos pos, ItemStack item) {
        if (lv.f_46443_) {
            return;
        }
        if (!item.m_41619_()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.1;
            double z = (double)pos.m_123343_() + 0.5;
            ItemEntity itemEntity = new ItemEntity(lv, x, y, z, item);
            lv.m_7967_((Entity)itemEntity);
        }
    }

    public static boolean insertOrElseThrow(@Nonnull Level lv, BlockPos pos, ItemStackHandler handler, ItemStack item, int start, int end) {
        ItemStack stack = item.m_41777_();
        for (int i = start; i < end; ++i) {
            if (!(stack = ItemStackUtil.addStackToSlotAsMuchAsPossible(handler, i, stack)).m_41619_()) continue;
            return true;
        }
        ItemStackUtil.drop(lv, pos, stack);
        return false;
    }

    public static ItemStack getDamagedItem(ItemStack original, int damage, Supplier<ItemStack> itemOnbrake) {
        ItemStack stack = original.m_41777_();
        int maxdur = stack.m_41776_();
        if (maxdur == 0) {
            return original;
        }
        int dur = stack.m_41773_();
        if ((dur += damage) >= maxdur) {
            return itemOnbrake.get();
        }
        stack.m_41721_(dur);
        return stack;
    }

    public static boolean damageItemInSlot(ItemStackHandler handler, int slot, int damage, Supplier<ItemStack> itemOnbrake) {
        ItemStack stack = handler.getStackInSlot(slot);
        ItemStack damaged = ItemStackUtil.getDamagedItem(stack, damage, itemOnbrake);
        handler.setStackInSlot(slot, damaged);
        return ItemStack.m_41656_((ItemStack)stack, (ItemStack)damaged);
    }
}

