/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.farming;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.block.BlockUtil;
import kandango.reagenica.block.farming.crop.AdvancedCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class AdvancedFarmland
extends FarmBlock {
    public static final IntegerProperty FERTILIZED = IntegerProperty.m_61631_((String)"fertilized", (int)0, (int)3);

    public AdvancedFarmland() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50093_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0))).m_61124_((Property)FERTILIZED, (Comparable)Integer.valueOf(3)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> state) {
        super.m_7926_(state);
        state.m_61104_(new Property[]{FERTILIZED});
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_121945_(facing));
        if (PlantType.CROP.equals(type)) {
            return state.m_60713_(Blocks.f_50093_) || state.m_60713_((Block)ChemiBlocks.ADVANCED_FARMLAND.get());
        }
        if (PlantType.PLAINS.equals(type)) {
            return state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50093_) || state.m_60713_((Block)ChemiBlocks.ADVANCED_FARMLAND.get());
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        int age;
        super.m_213898_(state, level, pos, random);
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        int chance = 1;
        BlockState abovestate = level.m_8055_(pos.m_7494_());
        if (abovestate.m_60734_() instanceof AdvancedCropBlock && (age = BlockUtil.getStatus(abovestate, CropBlock.f_52244_).orElse(0).intValue()) != 7) {
            chance = 6;
        }
        if (random.m_188503_(2000) < chance) {
            int fertilizer = BlockUtil.getStatus(state, FERTILIZED).orElse(0);
            int moisture = BlockUtil.getStatus(state, f_53243_).orElse(0);
            if (--fertilizer < 0) {
                level.m_7731_(pos, (BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture)), 3);
            } else {
                level.m_7731_(pos, (BlockState)((BlockState)((Block)ChemiBlocks.ADVANCED_FARMLAND.get()).m_49966_().m_61124_((Property)FERTILIZED, (Comparable)Integer.valueOf(fertilizer))).m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture)), 2);
            }
        }
    }
}

