/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.farming.grape;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.block.BlockUtil;
import kandango.reagenica.block.ShapeStream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapeBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SHAPE_SMALL = ShapeStream.create(5.0, 8.0, 5.0, 11.0, 16.0, 11.0).build();
    private static final VoxelShape SHAPE_LARGE = ShapeStream.create(3.0, 3.0, 3.0, 13.0, 16.0, 13.0).build();

    public GrapeBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60977_().m_60966_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60918_(SoundType.f_56758_));
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Vec3 vec3 = state.m_60824_(getter, pos);
        return BlockUtil.getStatus(state, AGE).map(age -> age == 3).orElse(false) != false ? SHAPE_LARGE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) : SHAPE_SMALL.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public ItemStack m_7397_(@Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ItemStack((ItemLike)ChemiBlocks.GRAPE.get());
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel slv, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        int i;
        if (!slv.isAreaLoaded(pos, 1)) {
            return;
        }
        if (slv.m_45524_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && rand.m_188503_(16) == 0) {
            slv.m_7731_(pos, this.getStateForAge(i + 1), 2);
        }
    }

    public int getAge(BlockState state) {
        return BlockUtil.getStatus(state, AGE).orElse(0);
    }

    public int getMaxAge() {
        return 3;
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
    }
}

