/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.farming.grape;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.block.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapePargola
extends Block {
    public static final int MAX_SPREAD = 7;
    public static final IntegerProperty SPREAD = IntegerProperty.m_61631_((String)"spread", (int)0, (int)7);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public GrapePargola() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)SPREAD, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SPREAD});
    }

    public BlockState getStateForSpread(int spread) {
        return (BlockState)this.m_49966_().m_61124_((Property)SPREAD, (Comparable)Integer.valueOf(spread));
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel slv, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (!slv.isAreaLoaded(pos, 1)) {
            return;
        }
        this.check(state, slv, pos, random);
        this.spread(state, slv, pos, random);
        this.fruit(state, slv, pos, random);
    }

    private void check(@Nonnull BlockState state, @Nonnull ServerLevel slv, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        int currentspread = BlockUtil.getStatus(state, SPREAD).orElse(7);
        boolean changedflag = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int relspr;
            BlockPos relative = pos.m_121945_(dir);
            BlockState relativestate = slv.m_8055_(relative);
            if (!relativestate.m_60713_((Block)ChemiBlocks.GRAPE_PARGOLA.get()) || currentspread <= (relspr = BlockUtil.getStatus(relativestate, SPREAD).orElse(7).intValue()) + 1) continue;
            currentspread = relspr + 1;
            changedflag = true;
        }
        if (changedflag) {
            slv.m_7731_(pos, this.getStateForSpread(currentspread), 4);
        }
    }

    private void spread(@Nonnull BlockState state, @Nonnull ServerLevel slv, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        int currentspread = BlockUtil.getStatus(state, SPREAD).orElse(7);
        if (currentspread < 7) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos relative = pos.m_121945_(dir);
                if (!slv.m_8055_(relative).m_60713_((Block)ChemiBlocks.PARGOLA.get()) || random.m_188503_(10) != 0) continue;
                slv.m_7731_(relative, this.getStateForSpread(currentspread + 1), 3);
            }
        }
    }

    private void fruit(@Nonnull BlockState state, @Nonnull ServerLevel slv, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        BlockPos fruitpos = pos.m_7495_();
        if (!slv.m_8055_(fruitpos).m_60795_()) {
            return;
        }
        int dense = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos rel = fruitpos.m_7918_(x, 0, z);
                if (!slv.m_8055_(rel).m_60713_((Block)ChemiBlocks.GRAPE_CROP.get())) continue;
                ++dense;
            }
        }
        if (random.m_188503_(dense * 3 + 6) == 0) {
            slv.m_7731_(fruitpos, ((Block)ChemiBlocks.GRAPE_CROP.get()).m_49966_(), 3);
        }
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return true;
    }

    public int m_7753_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return 1;
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }
}

