/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.fluid;

import java.util.function.Supplier;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.block.Yunohana;
import kandango.reagenica.block.fluid.ChemiFluidInterface;
import kandango.reagenica.block.fluid.ChemiFluidTypes;
import kandango.reagenica.block.fluid.OnsenFluidBlock;
import kandango.reagenica.block.fluid.OrganicFluidType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class ChemiOnsenObject
implements ChemiFluidInterface {
    private RegistryObject<FluidType> FluidType;
    private RegistryObject<FlowingFluid> StillFluid;
    private RegistryObject<FlowingFluid> FlowingFluid;
    private ForgeFlowingFluid.Properties Properties;
    private RegistryObject<Item> BucketItem;
    private RegistryObject<LiquidBlock> LiquidBlock;

    public ChemiOnsenObject(String name, int color, MobEffectInstance effect, Supplier<? extends Yunohana> yunohana) {
        this.FluidType = ChemiFluidTypes.FLUID_TYPES.register(name, () -> new OrganicFluidType(color));
        this.StillFluid = ChemiFluids.FLUIDS.register(name, () -> new ForgeFlowingFluid.Source(this.Properties));
        this.FlowingFluid = ChemiFluids.FLUIDS.register("flowing_" + name, () -> new ForgeFlowingFluid.Flowing(this.Properties));
        this.Properties = new ForgeFlowingFluid.Properties(this.FluidType, () -> this.StillFluid.get(), () -> this.FlowingFluid.get()).bucket(() -> (Item)this.BucketItem.get()).block(() -> (LiquidBlock)this.LiquidBlock.get());
        this.BucketItem = ChemiItems.registerandlist(name + "_bucket", () -> new BucketItem(this.StillFluid, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_)));
        this.LiquidBlock = ChemiBlocks.BLOCKS.register(name + "_block", () -> new OnsenFluidBlock(() -> (FlowingFluid)this.StillFluid.get(), BlockBehaviour.Properties.m_284310_().m_222994_().m_60910_().m_60978_(100.0f).m_60977_(), effect, yunohana));
    }

    @Override
    public FluidType getType() {
        return (FluidType)this.FluidType.get();
    }

    @Override
    public Fluid getFluid() {
        return (Fluid)this.StillFluid.get();
    }

    @Override
    public Fluid getFlowingFluid() {
        return (Fluid)this.FlowingFluid.get();
    }

    @Override
    public LiquidBlock getBlock() {
        return (LiquidBlock)this.LiquidBlock.get();
    }
}

