/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.fluid;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kandango.reagenica.block.Yunohana;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;

public class OnsenFluidBlock
extends LiquidBlock {
    private final MobEffectInstance effect;
    private final Supplier<? extends Yunohana> yunohana;

    public OnsenFluidBlock(Supplier<? extends FlowingFluid> fluid, BlockBehaviour.Properties props, MobEffectInstance effect, Supplier<? extends Yunohana> yunohana) {
        super(fluid, props);
        this.effect = effect;
        this.yunohana = yunohana;
    }

    public void m_214162_(@Nonnull BlockState state, @Nonnull Level lv, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (!lv.f_46443_) {
            return;
        }
        if (random.m_188501_() < 0.1f) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + random.m_188500_();
            lv.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 0.0, 0.02, 0.0);
        }
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel lv, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos yunohanapos;
                if (random.m_188503_(36) != 0 || !lv.m_46859_(yunohanapos = pos.m_7918_(x, 1, z))) continue;
                Yunohana yunohanaBlock = this.yunohana.get();
                BlockState yunohanastate = yunohanaBlock.m_49966_();
                boolean hadBlockNearby = false;
                for (Direction dir : Direction.values()) {
                    BlockPos rel = yunohanapos.m_121945_(dir);
                    BlockState relState = lv.m_8055_(rel);
                    if (relState.m_60783_((BlockGetter)lv, rel, dir.m_122424_())) {
                        yunohanastate = (BlockState)yunohanastate.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir), (Comparable)Boolean.valueOf(true));
                        hadBlockNearby = true;
                        continue;
                    }
                    yunohanastate = (BlockState)yunohanastate.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir), (Comparable)Boolean.valueOf(false));
                }
                if (!hadBlockNearby) continue;
                lv.m_7731_(yunohanapos, yunohanastate, 3);
            }
        }
    }

    public boolean m_6724_(@Nonnull BlockState state) {
        return true;
    }

    public void m_7892_(@Nonnull BlockState state, @Nonnull Level lv, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (lv.f_46443_) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (lv.m_46467_() % 20L == 0L) {
                living.m_7292_(new MobEffectInstance(this.effect));
            }
            if (living.m_20184_().m_82556_() > 1.0E-5 && living.f_19797_ % 25 == 0) {
                lv.m_5594_(null, living.m_20183_(), SoundEvents.f_12279_, SoundSource.PLAYERS, 0.2f, 0.9f + lv.f_46441_.m_188501_() * 0.2f);
            }
        }
    }

    public boolean m_6864_(@Nonnull BlockState state, @Nonnull BlockPlaceContext context) {
        return true;
    }
}

