/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.fluid;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class OrganicFluidType
extends FluidType {
    private final int color;

    public OrganicFluidType(int color) {
        super(FluidType.Properties.create().canDrown(true).canSwim(true).density(1000).viscosity(1000).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
        this.color = color;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("minecraft", "block/water_still");
            private static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("minecraft", "block/water_flow");
            private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("minecraft", "block/water_overlay");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getOverlayTexture() {
                return OVERLAY_TEXTURE;
            }

            public int getTintColor() {
                return OrganicFluidType.this.color;
            }
        });
    }
}

