/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.block.fluid.hotspring;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.material.Fluid;

public class OnsenTypes {
    public static final OnsenTypes SIMPLE = new OnsenTypes("simple", ChemiFluids.SIMPLE_HOTSPRING::getFluid, 0);
    public static final OnsenTypes SULFUR = new OnsenTypes("sulfur", ChemiFluids.SULFUR_HOTSPRING::getFluid, 1);
    public static final OnsenTypes CHLORIDE = new OnsenTypes("chloride", ChemiFluids.CHLORIDE_HOTSPRING::getFluid, 2);
    public static final OnsenTypes IRON = new OnsenTypes("iron", ChemiFluids.IRON_HOTSPRING::getFluid, 3);
    public static final OnsenTypes RADIOACTIVE = new OnsenTypes("radioactive", ChemiFluids.RADIOACTIVE_HOTSPRING::getFluid, 4);
    private final String nameKey;
    private final Supplier<Fluid> fluidObject;
    private final int ordinal;

    private OnsenTypes(String name, Supplier<Fluid> fluid, int ordinal) {
        this.nameKey = name;
        this.fluidObject = fluid;
        this.ordinal = ordinal;
    }

    public Component getNameComponent() {
        return Component.m_237115_((String)this.fluidObject.get().getFluidType().getDescriptionId());
    }

    public Component getLoreComponent() {
        return Component.m_237115_((String)("gui.reagenica.hotspring_lore_" + this.nameKey));
    }

    public Fluid getFluid() {
        return this.fluidObject.get();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public static OnsenTypes getOnsenTypeAt(@Nonnull ServerLevel lv, BlockPos pos) {
        return OnsenTypes.getOnsenTypeFrom(OnsenTypes.getGeology(lv, pos));
    }

    public static Climate.TargetPoint getGeology(@Nonnull ServerLevel lv, BlockPos pos) {
        RandomState randomState = lv.m_7726_().m_214994_();
        Climate.Sampler sampler = randomState.m_224579_();
        int qx = QuartPos.m_175400_((int)pos.m_123341_());
        int qy = QuartPos.m_175400_((int)pos.m_123342_());
        int qz = QuartPos.m_175400_((int)pos.m_123343_());
        Climate.TargetPoint tp = sampler.m_183445_(qx, qy, qz);
        return tp;
    }

    public static OnsenTypes getOnsenTypeFrom(Climate.TargetPoint tp) {
        float continentalness = Climate.m_186796_((long)tp.f_187005_());
        float temperature = Climate.m_186796_((long)tp.f_187003_());
        float humidity = Climate.m_186796_((long)tp.f_187004_());
        float erosion = Climate.m_186796_((long)tp.f_187006_());
        float weirdness = Climate.m_186796_((long)tp.f_187008_());
        if (continentalness < 0.0f && temperature < 0.65f) {
            return CHLORIDE;
        }
        if ((double)erosion < -0.2 && weirdness > 0.0f) {
            return SULFUR;
        }
        if ((double)continentalness > 0.3 && (double)erosion < -0.5 && weirdness < 0.0f) {
            return RADIOACTIVE;
        }
        if ((double)continentalness > 0.3 && (double)humidity < 0.3) {
            return IRON;
        }
        return SIMPLE;
    }

    public static OnsenTypes getOnsenTypeOf(int ordinal) {
        return switch (ordinal) {
            case 0 -> SIMPLE;
            case 1 -> SULFUR;
            case 2 -> CHLORIDE;
            case 3 -> IRON;
            case 4 -> RADIOACTIVE;
            default -> throw new IndexOutOfBoundsException();
        };
    }
}

