/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class ClientRenderUtil {
    public static void renderFluidInGui(GuiGraphics graphics, FluidStack fluid, BlockAndTintGetter level, BlockPos pos, int x, int y, int width, int height, int capacity) {
        if (fluid.isEmpty() || capacity <= 0) {
            return;
        }
        int amount = fluid.getAmount();
        int scaledHeight = (int)((float)amount / (float)capacity * (float)height);
        if (scaledHeight <= 0) {
            return;
        }
        FluidState fluidState = fluid.getFluid().m_76145_();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(fluid));
        int color = Minecraft.m_91087_().m_91298_().m_92577_(fluidState.m_76188_(), level, pos, 0);
        if (color == -1) {
            IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            color = ext.getTintColor(fluid);
        }
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        int yBottom = y + height;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        for (int i = 0; i < scaledHeight; i += 16) {
            for (int j = 0; j < width; j += 16) {
                int drawHeight = Math.min(16, scaledHeight - i);
                int drawWidth = Math.min(16, width - j);
                int drawY = yBottom - i - drawHeight;
                int drawX = x + j;
                float u0 = sprite.m_118409_();
                float u1 = sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * ((float)drawWidth / 16.0f);
                float v0 = sprite.m_118411_();
                float v1 = sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * ((float)drawHeight / 16.0f);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                Matrix4f matrix = poseStack.m_85850_().m_252922_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buffer.m_252986_(matrix, (float)drawX, (float)(drawY + drawHeight), 0.0f).m_7421_(u0, v1).m_5752_();
                buffer.m_252986_(matrix, (float)(drawX + drawWidth), (float)(drawY + drawHeight), 0.0f).m_7421_(u1, v1).m_5752_();
                buffer.m_252986_(matrix, (float)(drawX + drawWidth), (float)drawY, 0.0f).m_7421_(u1, v0).m_5752_();
                buffer.m_252986_(matrix, (float)drawX, (float)drawY, 0.0f).m_7421_(u0, v0).m_5752_();
                tesselator.m_85914_();
            }
        }
        poseStack.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void renderEnergyInGui(GuiGraphics graphics, int energy, BlockAndTintGetter level, BlockPos pos, int x, int y, int width, int height, int capacity) {
        ClientRenderUtil.renderFluidInGui(graphics, new FluidStack((Fluid)Fluids.f_76195_, energy), level, pos, x, y, width, height, capacity);
    }

    public static void renderEnergyInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int energy, int maxenergy, int x, int y, int ex, int ey, int gaugewidth, int gaugeheight) {
        int barheight = gaugeheight * energy / (maxenergy != 0 ? maxenergy : Integer.MAX_VALUE);
        graphics.m_280218_(texture, leftPos + x, topPos + y + gaugeheight - barheight, ex, ey + gaugeheight - barheight, gaugewidth, barheight);
    }

    public static void renderHorizontalInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int amount, int max, int x, int y, int ex, int ey, int gaugewidth, int gaugeheight) {
        int barwidth = gaugewidth * amount / (max != 0 ? max : Integer.MAX_VALUE);
        graphics.m_280218_(texture, leftPos + x, topPos + y, ex, ey, barwidth, gaugeheight);
    }

    public static void renderFireInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int fireheight, int x, int y, int fx, int fy) {
        graphics.m_280218_(texture, leftPos + x, topPos + y + 14 - fireheight, fx, fy + 14 - fireheight, 14, fireheight);
    }

    public static void renderFireInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int fuel, int maxfuel, int x, int y, int fx, int fy) {
        int fireheight = ClientRenderUtil.fireHeight(fuel, maxfuel);
        graphics.m_280218_(texture, leftPos + x, topPos + y + 14 - fireheight, fx, fy + 14 - fireheight, 14, fireheight);
    }

    public static void renderFireAtDefaultposInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int fuel, int maxfuel, int x, int y) {
        int fireheight = ClientRenderUtil.fireHeight(fuel, maxfuel);
        graphics.m_280218_(texture, leftPos + x, topPos + y + 14 - fireheight, 176, 14 - fireheight, 14, fireheight);
    }

    private static int fireHeight(int remain, int max) {
        if (remain == 0) {
            return 0;
        }
        if (max <= 0 || remain > max) {
            return 0;
        }
        int h = ClientRenderUtil.ceilDiv(12 * remain, max);
        return h + 1;
    }

    private static int ceilDiv(int a, int b) {
        return (a + b - 1) / b;
    }

    public static void renderArrowInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int arrowlength, int x, int y, int ax, int ay) {
        graphics.m_280218_(texture, leftPos + x, topPos + y, ax, ay, arrowlength, 16);
    }

    public static void renderArrowInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int progress, int maxprogress, int x, int y, int ax, int ay) {
        int arrowlength = 24 * progress / maxprogress;
        graphics.m_280218_(texture, leftPos + x, topPos + y, ax, ay, arrowlength, 16);
    }

    public static void renderArrowAtDefaultposInGui(ResourceLocation texture, GuiGraphics graphics, int leftPos, int topPos, int progress, int maxprogress, int x, int y) {
        int arrowlength = 24 * progress / maxprogress;
        graphics.m_280218_(texture, leftPos + x, topPos + y, 176, 14, arrowlength, 16);
    }
}

