/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record GlowingSporeOptions(float r, float g, float b) implements ParticleOptions
{
    public static final Codec<GlowingSporeOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(o -> Float.valueOf(o.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(o -> Float.valueOf(o.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(o -> Float.valueOf(o.b))).apply((Applicative)instance, GlowingSporeOptions::new));
    public static final ParticleOptions.Deserializer<GlowingSporeOptions> DESERIALIZER = new Deserializer();

    public ParticleType<?> m_6012_() {
        return (ParticleType)ChemiParticles.GLOWING_SPORE.get();
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buf) {
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%f %f %f", Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }

    private static class Deserializer
    implements ParticleOptions.Deserializer<GlowingSporeOptions> {
        private Deserializer() {
        }

        public GlowingSporeOptions fromCommand(@Nonnull ParticleType<GlowingSporeOptions> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            return new GlowingSporeOptions(r, g, b);
        }

        public GlowingSporeOptions fromNetwork(@Nonnull ParticleType<GlowingSporeOptions> type, @Nonnull FriendlyByteBuf buf) {
            float r = buf.readFloat();
            float g = buf.readFloat();
            float b = buf.readFloat();
            return new GlowingSporeOptions(r, g, b);
        }
    }
}

