/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class FluidBlockEntityRenderer {
    public static void renderFluidCube(PoseStack poseStack, MultiBufferSource buffersource, FluidStack fluidStack, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, BlockAndTintGetter level, BlockPos pos, int light) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        FluidState fluidState = fluid.m_76145_();
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)level, (BlockPos)pos, (FluidState)fluidState);
        TextureAtlasSprite sprite = sprites[0];
        VertexConsumer buffer = buffersource.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_()));
        int color = Minecraft.m_91087_().m_91298_().m_92577_(fluidState.m_76188_(), level, pos, 0);
        if (color == -1) {
            color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        }
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normal = pose.m_252943_();
        float u1 = sprite.m_118409_();
        float u2 = sprite.m_118410_();
        float v1 = sprite.m_118411_();
        float v2 = sprite.m_118412_();
        RenderingHappySet renderingkit = new RenderingHappySet(buffer, matrix, r, g, b, a, u1, v1, u2, v2, light, normal);
        FluidBlockEntityRenderer.renderToUpper(renderingkit, minX, minZ, maxX, maxZ, maxY);
        FluidBlockEntityRenderer.renderToLower(renderingkit, minX, minZ, maxX, maxZ, minY);
        FluidBlockEntityRenderer.renderToNorthern(renderingkit, minX, minY, maxX, maxY, minZ);
        FluidBlockEntityRenderer.renderToSouthern(renderingkit, minX, minY, maxX, maxY, maxZ);
        FluidBlockEntityRenderer.renderToWestern(renderingkit, minZ, minY, maxZ, maxY, minX);
        FluidBlockEntityRenderer.renderToEastern(renderingkit, minZ, minY, maxZ, maxY, maxX);
    }

    public static void renderFlowingFluidCube(PoseStack poseStack, MultiBufferSource buffersource, FluidStack fluidStack, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, BlockAndTintGetter level, BlockPos pos, int light) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        FluidState fluidState = fluid.m_76145_();
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)level, (BlockPos)pos, (FluidState)fluidState);
        TextureAtlasSprite sprite = sprites[0];
        TextureAtlasSprite sprite_flowing = sprites[1];
        VertexConsumer buffer = buffersource.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_()));
        int color = Minecraft.m_91087_().m_91298_().m_92577_(fluidState.m_76188_(), level, pos, 0);
        if (color == -1) {
            color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        }
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normal = pose.m_252943_();
        RenderingHappySet renderingkit = new RenderingHappySet(buffer, matrix, r, g, b, a, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), light, normal);
        RenderingHappySet flowrenderingkit = new RenderingHappySet(buffer, matrix, r, g, b, a, sprite_flowing.m_118409_(), sprite_flowing.m_118412_(), sprite_flowing.m_118410_(), sprite_flowing.m_118411_(), light, normal);
        FluidBlockEntityRenderer.renderToUpper(renderingkit, minX, minZ, maxX, maxZ, maxY);
        FluidBlockEntityRenderer.renderToLower(renderingkit, minX, minZ, maxX, maxZ, minY);
        FluidBlockEntityRenderer.renderToNorthern(flowrenderingkit, minX, minY, maxX, maxY, minZ);
        FluidBlockEntityRenderer.renderToSouthern(flowrenderingkit, minX, minY, maxX, maxY, maxZ);
        FluidBlockEntityRenderer.renderToWestern(flowrenderingkit, minZ, minY, maxZ, maxY, minX);
        FluidBlockEntityRenderer.renderToEastern(flowrenderingkit, minZ, minY, maxZ, maxY, maxX);
    }

    public static void renderToUpper(RenderingHappySet kit, float minX, float minZ, float maxX, float maxZ, float Y) {
        VertexConsumer buffer = kit.buffer;
        Matrix4f matrix = kit.matrix;
        float r = kit.r;
        float g = kit.g;
        float b = kit.b;
        float a = kit.a;
        float u1 = kit.u1;
        float v1 = kit.v1;
        float u2 = kit.u2;
        float v2 = kit.v2;
        int light = kit.light;
        Matrix3f normal = kit.normal;
        for (float ptr_X = minX; ptr_X < maxX; ptr_X += 1.0f) {
            for (float ptr_Z = minZ; ptr_Z < maxZ; ptr_Z += 1.0f) {
                float ptr_mX = Math.min(ptr_X + 1.0f, maxX);
                float ptr_mZ = Math.min(ptr_Z + 1.0f, maxZ);
                float xu2 = u1 + (ptr_mX - ptr_X) * (u2 - u1);
                float xv2 = v1 + (ptr_mZ - ptr_Z) * (v2 - v1);
                buffer.m_252986_(matrix, ptr_X, Y, ptr_mZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_mX, Y, ptr_mZ).m_85950_(r, g, b, a).m_7421_(xu2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_mX, Y, ptr_Z).m_85950_(r, g, b, a).m_7421_(xu2, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_X, Y, ptr_Z).m_85950_(r, g, b, a).m_7421_(u1, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
    }

    public static void renderToLower(RenderingHappySet kit, float minX, float minZ, float maxX, float maxZ, float Y) {
        VertexConsumer buffer = kit.buffer;
        Matrix4f matrix = kit.matrix;
        float r = kit.r;
        float g = kit.g;
        float b = kit.b;
        float a = kit.a;
        float u1 = kit.u1;
        float v1 = kit.v1;
        float u2 = kit.u2;
        float v2 = kit.v2;
        int light = kit.light;
        Matrix3f normal = kit.normal;
        for (float ptr_X = minX; ptr_X < maxX; ptr_X += 1.0f) {
            for (float ptr_Z = minZ; ptr_Z < maxZ; ptr_Z += 1.0f) {
                float ptr_mX = Math.min(ptr_X + 1.0f, maxX);
                float ptr_mZ = Math.min(ptr_Z + 1.0f, maxZ);
                float xu2 = u1 + (ptr_mX - ptr_X) * (u2 - u1);
                float xv2 = v1 + (ptr_mZ - ptr_Z) * (v2 - v1);
                buffer.m_252986_(matrix, ptr_X, Y, ptr_mZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_mX, Y, ptr_mZ).m_85950_(r, g, b, a).m_7421_(xu2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_mX, Y, ptr_Z).m_85950_(r, g, b, a).m_7421_(xu2, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_X, Y, ptr_Z).m_85950_(r, g, b, a).m_7421_(u1, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            }
        }
    }

    public static void renderToNorthern(RenderingHappySet kit, float minX, float minY, float maxX, float maxY, float Z) {
        VertexConsumer buffer = kit.buffer;
        Matrix4f matrix = kit.matrix;
        float r = kit.r;
        float g = kit.g;
        float b = kit.b;
        float a = kit.a;
        float u1 = kit.u1;
        float v1 = kit.v1;
        float u2 = kit.u2;
        float v2 = kit.v2;
        int light = kit.light;
        Matrix3f normal = kit.normal;
        for (float ptr_X = minX; ptr_X < maxX; ptr_X += 1.0f) {
            for (float ptr_Y = minY; ptr_Y < maxY; ptr_Y += 1.0f) {
                float ptr_mX = Math.min(ptr_X + 1.0f, maxX);
                float ptr_mY = Math.min(ptr_Y + 1.0f, maxY);
                float xu2 = u1 + (ptr_mX - ptr_X) * (u2 - u1);
                float xv2 = v1 + (ptr_mY - ptr_Y) * (v2 - v1);
                buffer.m_252986_(matrix, ptr_X, ptr_Y, Z).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_mX, ptr_Y, Z).m_85950_(r, g, b, a).m_7421_(xu2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_mX, ptr_mY, Z).m_85950_(r, g, b, a).m_7421_(xu2, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_X, ptr_mY, Z).m_85950_(r, g, b, a).m_7421_(u1, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            }
        }
    }

    public static void renderToSouthern(RenderingHappySet kit, float minX, float minY, float maxX, float maxY, float Z) {
        VertexConsumer buffer = kit.buffer;
        Matrix4f matrix = kit.matrix;
        float r = kit.r;
        float g = kit.g;
        float b = kit.b;
        float a = kit.a;
        float u1 = kit.u1;
        float v1 = kit.v1;
        float u2 = kit.u2;
        float v2 = kit.v2;
        int light = kit.light;
        Matrix3f normal = kit.normal;
        for (float ptr_X = minX; ptr_X < maxX; ptr_X += 1.0f) {
            for (float ptr_Y = minY; ptr_Y < maxY; ptr_Y += 1.0f) {
                float ptr_mX = Math.min(ptr_X + 1.0f, maxX);
                float ptr_mY = Math.min(ptr_Y + 1.0f, maxY);
                float xu2 = u1 + (ptr_mX - ptr_X) * (u2 - u1);
                float xv2 = v1 + (ptr_mY - ptr_Y) * (v2 - v1);
                buffer.m_252986_(matrix, ptr_mX, ptr_Y, Z).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_X, ptr_Y, Z).m_85950_(r, g, b, a).m_7421_(xu2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_X, ptr_mY, Z).m_85950_(r, g, b, a).m_7421_(xu2, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix, ptr_mX, ptr_mY, Z).m_85950_(r, g, b, a).m_7421_(u1, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            }
        }
    }

    public static void renderToWestern(RenderingHappySet kit, float minZ, float minY, float maxZ, float maxY, float X) {
        VertexConsumer buffer = kit.buffer;
        Matrix4f matrix = kit.matrix;
        float r = kit.r;
        float g = kit.g;
        float b = kit.b;
        float a = kit.a;
        float u1 = kit.u1;
        float v1 = kit.v1;
        float u2 = kit.u2;
        float v2 = kit.v2;
        int light = kit.light;
        Matrix3f normal = kit.normal;
        for (float ptr_Z = minZ; ptr_Z < maxZ; ptr_Z += 1.0f) {
            for (float ptr_Y = minY; ptr_Y < maxY; ptr_Y += 1.0f) {
                float ptr_mZ = Math.min(ptr_Z + 1.0f, maxZ);
                float ptr_mY = Math.min(ptr_Y + 1.0f, maxY);
                float xu2 = u1 + (ptr_mZ - ptr_Z) * (u2 - u1);
                float xv2 = v1 + (ptr_mY - ptr_Y) * (v2 - v1);
                buffer.m_252986_(matrix, X, ptr_Y, ptr_mZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, X, ptr_Y, ptr_Z).m_85950_(r, g, b, a).m_7421_(xu2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, X, ptr_mY, ptr_Z).m_85950_(r, g, b, a).m_7421_(xu2, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, X, ptr_mY, ptr_mZ).m_85950_(r, g, b, a).m_7421_(u1, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            }
        }
    }

    public static void renderToEastern(RenderingHappySet kit, float minZ, float minY, float maxZ, float maxY, float X) {
        VertexConsumer buffer = kit.buffer;
        Matrix4f matrix = kit.matrix;
        float r = kit.r;
        float g = kit.g;
        float b = kit.b;
        float a = kit.a;
        float u1 = kit.u1;
        float v1 = kit.v1;
        float u2 = kit.u2;
        float v2 = kit.v2;
        int light = kit.light;
        Matrix3f normal = kit.normal;
        for (float ptr_Z = minZ; ptr_Z < maxZ; ptr_Z += 1.0f) {
            for (float ptr_Y = minY; ptr_Y < maxY; ptr_Y += 1.0f) {
                float ptr_mZ = Math.min(ptr_Z + 1.0f, maxZ);
                float ptr_mY = Math.min(ptr_Y + 1.0f, maxY);
                float xu2 = u1 + (ptr_mZ - ptr_Z) * (u2 - u1);
                float xv2 = v1 + (ptr_mY - ptr_Y) * (v2 - v1);
                buffer.m_252986_(matrix, X, ptr_Y, ptr_Z).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, X, ptr_Y, ptr_mZ).m_85950_(r, g, b, a).m_7421_(xu2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, X, ptr_mY, ptr_mZ).m_85950_(r, g, b, a).m_7421_(xu2, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix, X, ptr_mY, ptr_Z).m_85950_(r, g, b, a).m_7421_(u1, xv2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            }
        }
    }

    private record RenderingHappySet(VertexConsumer buffer, Matrix4f matrix, float r, float g, float b, float a, float u1, float v1, float u2, float v2, int light, Matrix3f normal) {
    }
}

