/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import kandango.reagenica.block.HeatFurnace;
import kandango.reagenica.block.entity.electrical.HeatFurnaceBlockEntity;
import kandango.reagenica.client.renderer.FluidBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class HeatFurnaceFluidRenderer
implements BlockEntityRenderer<HeatFurnaceBlockEntity> {
    public HeatFurnaceFluidRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull HeatFurnaceBlockEntity furnace, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        FluidStack fluidin = furnace.getInputTank().getFluid();
        FluidStack fluidout = furnace.getOutputTank().getFluid();
        if (fluidin == null || fluidout == null) {
            return;
        }
        if (fluidin.isEmpty() && fluidout.isEmpty()) {
            return;
        }
        Level level = furnace.m_58904_();
        BlockPos pos = furnace.m_58899_();
        BlockState state = furnace.m_58900_();
        if (!state.m_61138_((Property)HeatFurnace.FACING)) {
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)HeatFurnace.FACING);
        float cube_pix = 0.0625f;
        float offset = 0.001f;
        float heightin = (float)fluidin.getAmount() / (float)furnace.getInputTank().getCapacity() * 0.9f + 0.0625f + 0.001f;
        float heightout = (float)fluidout.getAmount() / (float)furnace.getOutputTank().getCapacity() * 0.9f + 0.0625f + 0.001f;
        SpaceFloat inputstart = this.rotate(new SpaceFloat(0.6885f, 0.0635f, 0.4385f), this.torot(dir));
        SpaceFloat inputend = this.rotate(new SpaceFloat(0.9365f, heightin, 0.9365f), this.torot(dir));
        SpaceFloat outputstart = this.rotate(new SpaceFloat(0.0635f, 0.0635f, 0.4385f), this.torot(dir));
        SpaceFloat outputend = this.rotate(new SpaceFloat(0.3115f, heightout, 0.9365f), this.torot(dir));
        poseStack.m_85836_();
        FluidBlockEntityRenderer.renderFluidCube(poseStack, bufferSource, fluidin, inputstart.x, inputstart.y, inputstart.z, inputend.x, inputend.y, inputend.z, (BlockAndTintGetter)level, pos, 0xF000F0);
        FluidBlockEntityRenderer.renderFluidCube(poseStack, bufferSource, fluidout, outputstart.x, outputstart.y, outputstart.z, outputend.x, outputend.y, outputend.z, (BlockAndTintGetter)level, pos, 0xF000F0);
        poseStack.m_85849_();
    }

    private SpaceFloat rotate(SpaceFloat coord, int rot) {
        float x = coord.x();
        float y = coord.y();
        float z = coord.z();
        if (rot == 0) {
            return new SpaceFloat(x, y, z);
        }
        if (rot == 1) {
            return new SpaceFloat(z, y, 1.0f - x);
        }
        if (rot == 2) {
            return new SpaceFloat(1.0f - x, y, 1.0f - z);
        }
        if (rot == 3) {
            return new SpaceFloat(1.0f - z, y, x);
        }
        throw new IllegalArgumentException("Only 0-3 is allowed in rot");
    }

    private int torot(Direction dir) {
        if (dir == Direction.NORTH) {
            return 0;
        }
        if (dir == Direction.WEST) {
            return 1;
        }
        if (dir == Direction.SOUTH) {
            return 2;
        }
        return 3;
    }

    private record SpaceFloat(float x, float y, float z) {
    }
}

