/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import kandango.reagenica.block.entity.LargeTankCoreBlockEntity;
import kandango.reagenica.client.renderer.FluidBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class LargeTankRenderer
implements BlockEntityRenderer<LargeTankCoreBlockEntity> {
    public LargeTankRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull LargeTankCoreBlockEntity be, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        FluidTank tank = be.getFluidTank();
        if (tank == null || tank.isEmpty()) {
            return;
        }
        FluidStack fluid = tank.getFluid();
        int amount = tank.getFluidAmount();
        int tankmax = tank.getCapacity();
        Level level = be.m_58904_();
        BlockPos pos = be.m_58899_();
        LargeTankCoreBlockEntity.TankSize size = be.getTankSize();
        if (size == null) {
            return;
        }
        int tankwidth = size.width();
        int tankheight = size.height();
        float cube_min = -(tankwidth - 1);
        float cube_max = 1.0f + (float)(tankwidth - 1);
        float offset = 0.01f;
        float min = cube_min + 0.01f;
        float max = cube_max - 0.01f;
        float height = Math.min(1.0f + (float)(tankheight - 1) * Math.min((float)amount / (float)tankmax, 1.0f), (float)tankheight - 0.01f);
        poseStack.m_85836_();
        FluidBlockEntityRenderer.renderFluidCube(poseStack, bufferSource, fluid, min, 1.01f, min, max, height, max, (BlockAndTintGetter)level, pos, 0xF000F0);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(@Nonnull LargeTankCoreBlockEntity be) {
        return true;
    }
}

