/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiGeometry;
import kandango.reagenica.block.BlockUtil;
import kandango.reagenica.block.OnsenFiller;
import kandango.reagenica.block.entity.OnsenFillerBlockEntity;
import kandango.reagenica.client.renderer.FluidBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class OnsenFillerFluidRenderer
implements BlockEntityRenderer<OnsenFillerBlockEntity> {
    public OnsenFillerFluidRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull OnsenFillerBlockEntity filler, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        FluidStack fluid = new FluidStack(filler.getRenderingFluid(), packedOverlay);
        if (fluid.isEmpty()) {
            return;
        }
        Level level = filler.m_58904_();
        BlockPos pos = filler.m_58899_();
        BlockState state = filler.m_58900_();
        Direction rotation = BlockUtil.getStatus(state, OnsenFiller.FACING).orElse(Direction.NORTH);
        Block block = state.m_60734_();
        poseStack.m_85836_();
        if (block instanceof OnsenFiller) {
            OnsenFiller fillerBlock = (OnsenFiller)block;
            Collection<ChemiGeometry> waters = fillerBlock.waterFlows();
            for (ChemiGeometry cube : waters) {
                ChemiGeometry place = cube.rotate(rotation).flush();
                ChemiGeometry.Space start = place.getLeastPole();
                ChemiGeometry.Space end = place.getMostPole();
                FluidBlockEntityRenderer.renderFlowingFluidCube(poseStack, bufferSource, fluid, start.fx(), start.fy(), start.fz(), end.fx(), end.fy(), end.fz(), (BlockAndTintGetter)level, pos, packedLight);
            }
        }
        poseStack.m_85849_();
    }
}

