/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import kandango.reagenica.block.StackLamp;
import kandango.reagenica.block.entity.StackLampBlockEntity;
import kandango.reagenica.block.entity.lamp.LampState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class StackLampRenderer
implements BlockEntityRenderer<StackLampBlockEntity> {
    public StackLampRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@Nonnull StackLampBlockEntity be, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        BlockState blockstate = level.m_8055_(be.m_58899_());
        if (!blockstate.m_61138_((Property)StackLamp.FACING)) {
            return;
        }
        Direction facing = (Direction)blockstate.m_61143_((Property)StackLamp.FACING);
        ResourceLocation TEXTURE = new ResourceLocation("reagenica", "textures/block/stack_lamp_light.png");
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        poseStack.m_85836_();
        for (int stack = 0; stack <= 2; ++stack) {
            LampState lampstate = be.getLampStates().getLampState(stack);
            this.drawCube(poseStack, consumer, this.getSpaces(facing, stack), this.getColor(stack, lampstate, level), facing);
        }
        poseStack.m_85849_();
    }

    private void drawCube(PoseStack poseStack, VertexConsumer consumer, CubicFloat cube, ColorFloats col, Direction facing) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        int fullBright = 0xF000F0;
        float offset = 0.02f;
        float x1 = cube.x1() / 16.0f;
        float y1 = cube.y1() / 16.0f;
        float z1 = cube.z1() / 16.0f;
        float x2 = cube.x2() / 16.0f;
        float y2 = cube.y2() / 16.0f;
        float z2 = cube.z2() / 16.0f;
        if (facing != Direction.EAST && facing != Direction.WEST) {
            x1 += 0.02f;
            x2 -= 0.02f;
        }
        if (facing != Direction.UP && facing != Direction.DOWN) {
            y1 += 0.02f;
            y2 -= 0.02f;
        }
        if (facing != Direction.NORTH && facing != Direction.SOUTH) {
            z1 += 0.02f;
            z2 -= 0.02f;
        }
        float r = col.r();
        float g = col.g();
        float b = col.b();
        float a = col.a();
        consumer.m_252986_(mat, x1, y2, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y2, z1).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y2, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x1, y2, z2).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x1, y1, z2).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y1, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y1, z1).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x1, y1, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x1, y1, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(mat, x2, y1, z1).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(mat, x2, y2, z1).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(mat, x1, y2, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(mat, x2, y1, z2).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(mat, x1, y1, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(mat, x1, y2, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(mat, x2, y2, z2).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(mat, x1, y1, z2).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x1, y1, z1).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x1, y2, z1).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x1, y2, z2).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y1, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y1, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y2, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(mat, x2, y2, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(fullBright).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private CubicFloat getSpaces(Direction facing, int stack) {
        if (facing == Direction.UP) {
            return new CubicFloat(6.0f, 3.0f + (float)stack * 4.0f, 6.0f, 10.0f, 6.0f + (float)stack * 4.0f, 10.0f);
        }
        if (facing == Direction.DOWN) {
            return new CubicFloat(6.0f, 10.0f - (float)stack * 4.0f, 6.0f, 10.0f, 13.0f - (float)stack * 4.0f, 10.0f);
        }
        if (facing == Direction.NORTH) {
            return new CubicFloat(6.0f, 6.0f, 10.0f - (float)stack * 4.0f, 10.0f, 10.0f, 13.0f - (float)stack * 4.0f);
        }
        if (facing == Direction.SOUTH) {
            return new CubicFloat(6.0f, 6.0f, 3.0f + (float)stack * 4.0f, 10.0f, 10.0f, 6.0f + (float)stack * 4.0f);
        }
        if (facing == Direction.WEST) {
            return new CubicFloat(10.0f - (float)stack * 4.0f, 6.0f, 6.0f, 13.0f - (float)stack * 4.0f, 10.0f, 10.0f);
        }
        if (facing == Direction.EAST) {
            return new CubicFloat(3.0f + (float)stack * 4.0f, 6.0f, 6.0f, 6.0f + (float)stack * 4.0f, 10.0f, 10.0f);
        }
        throw new IllegalArgumentException();
    }

    private ColorFloats getColor(int stack, LampState state, Level lv) {
        if (stack == 0) {
            if (state == LampState.ON) {
                return ColorFloats.getColor(65407);
            }
            if (state == LampState.OFF) {
                return ColorFloats.getColor(1128960);
            }
            return this.litOnBlink(lv) ? ColorFloats.getColor(65407) : ColorFloats.getColor(1128960);
        }
        if (stack == 1) {
            if (state == LampState.ON) {
                return ColorFloats.getColor(16762624);
            }
            if (state == LampState.OFF) {
                return ColorFloats.getColor(4337408);
            }
            return this.litOnBlink(lv) ? ColorFloats.getColor(16762624) : ColorFloats.getColor(4337408);
        }
        if (stack == 2) {
            if (state == LampState.ON) {
                return ColorFloats.getColor(0xFF0000);
            }
            if (state == LampState.OFF) {
                return ColorFloats.getColor(0x3A0000);
            }
            return this.litOnBlink(lv) ? ColorFloats.getColor(0xFF0000) : ColorFloats.getColor(0x3A0000);
        }
        return null;
    }

    private boolean litOnBlink(Level lv) {
        long time = lv.m_46467_();
        return time / 10L % 2L == 0L;
    }

    private record CubicFloat(float x1, float y1, float z1, float x2, float y2, float z2) {
    }

    private record ColorFloats(float r, float g, float b, float a) {
        static ColorFloats getColor(int color) {
            return new ColorFloats((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
        }
    }
}

