/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import kandango.reagenica.block.TradingStall;
import kandango.reagenica.block.entity.TradingStallBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class TradingStallRenderer
implements BlockEntityRenderer<TradingStallBlockEntity> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public TradingStallRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull TradingStallBlockEntity blockentity, float partialticks, @Nonnull PoseStack pose, @Nonnull MultiBufferSource mbs, int combinedLight, int combinedOverlay) {
        ItemStackHandler handler = blockentity.getItemHandler();
        Direction facing = (Direction)blockentity.m_58900_().m_61143_((Property)TradingStall.FACING);
        float yRotation = -facing.m_122428_().m_122435_();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                ItemStack stack = handler.getStackInSlot(i * 9 + j);
                if (stack.m_41619_()) continue;
                pose.m_85836_();
                SpaceFloat floats = new SpaceFloat((float)i / 5.0f + 0.3f, 0.1f, (float)j / 10.0f + 0.1f);
                SpaceFloat rotfloats = this.rotate(floats, this.torot(facing));
                pose.m_252880_(rotfloats.x(), rotfloats.y(), rotfloats.z());
                pose.m_252781_(Axis.f_252436_.m_252977_(yRotation));
                pose.m_252781_(Axis.f_252436_.m_252977_(80.0f));
                pose.m_252781_(Axis.f_252529_.m_252977_(15.0f));
                pose.m_252781_(Axis.f_252403_.m_252977_(15.0f));
                pose.m_85841_(0.3f, 0.3f, 0.3f);
                this.itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, pose, mbs, blockentity.m_58904_(), 0);
                pose.m_85849_();
            }
        }
    }

    private SpaceFloat rotate(SpaceFloat coord, int rot) {
        float x = coord.x();
        float y = coord.y();
        float z = coord.z();
        if (rot == 0) {
            return new SpaceFloat(x, y, z);
        }
        if (rot == 1) {
            return new SpaceFloat(z, y, 1.0f - x);
        }
        if (rot == 2) {
            return new SpaceFloat(1.0f - x, y, 1.0f - z);
        }
        if (rot == 3) {
            return new SpaceFloat(1.0f - z, y, x);
        }
        throw new IllegalArgumentException("Only 0-3 is allowed in rot");
    }

    private int torot(Direction dir) {
        if (dir == Direction.WEST) {
            return 0;
        }
        if (dir == Direction.NORTH) {
            return 1;
        }
        if (dir == Direction.EAST) {
            return 2;
        }
        return 3;
    }

    private record SpaceFloat(float x, float y, float z) {
    }
}

