/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.generator;

import java.util.List;
import java.util.Set;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.generator.BlockLootType;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ChemiLootTableProvider
extends LootTableProvider {
    public ChemiLootTableProvider(PackOutput output) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ChemiBlockLootTables::new, LootContextParamSets.f_81421_)));
    }

    private static class ChemiBlockLootTables
    extends BlockLootSubProvider {
        protected ChemiBlockLootTables() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            for (BlockLootType block : ChemiBlocks.listBlocks) {
                if (block.type() == BlockLootType.BlockType.NORMAL) {
                    this.m_245724_((Block)block.blockreg().get());
                    continue;
                }
                if (block.type() == BlockLootType.BlockType.ORES) {
                    this.m_246481_((Block)block.blockreg().get(), ore -> this.m_246109_((Block)ore, (Item)block.item().get()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)block.count()))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)));
                    continue;
                }
                if (block.type() == BlockLootType.BlockType.MACHINE) {
                    this.m_246481_((Block)block.blockreg().get(), machine -> this.m_246180_((Block)machine));
                    continue;
                }
                if (block.type() == BlockLootType.BlockType.MACHINE_SAVEENERGY) {
                    this.m_246481_((Block)block.blockreg().get(), machine -> this.m_246180_((Block)machine).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Electric", "BlockEntityTag.Electric")));
                    continue;
                }
                if (block.type() == BlockLootType.BlockType.SILKTOUCH) {
                    this.m_246481_((Block)block.blockreg().get(), glass -> ChemiBlockLootTables.m_245335_((ItemLike)glass));
                    continue;
                }
                if (block.type() == BlockLootType.BlockType.PLANTS) {
                    this.m_246481_((Block)block.blockreg().get(), plant -> this.m_245238_((Block)plant, (Item)block.item().get(), (Item)block.item().get(), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)plant).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7))));
                    continue;
                }
                if (block.type() == BlockLootType.BlockType.NONE) {
                    this.m_247577_((Block)block.blockreg().get(), ChemiBlockLootTables.m_246386_());
                    continue;
                }
                if (block.type() != BlockLootType.BlockType.MANUAL) continue;
                this.m_247577_((Block)block.blockreg().get(), ChemiBlockLootTables.m_246386_());
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return ChemiBlocks.BLOCKS.getEntries().stream().map(e -> (Block)e.get()).toList();
        }
    }
}

