/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.item;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiTags;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.screen.OreBagMenu;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreBag
extends Item {
    public OreBag() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!level.f_46443_) {
            ItemStack stack = player.m_21120_(hand);
            int slot = this.findSlot(player, stack);
            if (slot == -1) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, inventory, p) -> new OreBagMenu(windowId, inventory, slot), (Component)Component.m_237115_((String)"gui.reagenica.ore_bag")), buf -> buf.m_130130_(slot));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    private int findSlot(Player player, ItemStack target) {
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!ItemStack.m_150942_((ItemStack)inv.m_8020_(i), (ItemStack)target)) continue;
            return i;
        }
        return -1;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        IItemHandler handler;
        LazyOptional maybeitemhandler;
        CompoundTag tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        if ((maybeitemhandler = stack.getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent() && (handler = (IItemHandler)maybeitemhandler.orElseThrow(() -> new IllegalStateException("what happened in this moment!?"))) instanceof INBTSerializable) {
            INBTSerializable serializable = (INBTSerializable)handler;
            tag.m_128365_("Inventory", serializable.serializeNBT());
        }
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        super.readShareTag(stack, tag);
        if (tag != null && tag.m_128441_("Inventory")) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (handler instanceof INBTSerializable) {
                    INBTSerializable genericserializable;
                    INBTSerializable serializable = genericserializable = (INBTSerializable)handler;
                    serializable.deserializeNBT((Tag)tag.m_128469_("Inventory"));
                }
            });
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new OreBagProvider(nbt);
    }

    public static class OreBagProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final ItemStackHandler handler = new ItemStackHandler(27){

            public boolean isItemValid(int slot, @Nullable ItemStack stack) {
                return OreBagProvider.isAcceptableItem(stack);
            }
        };
        private final LazyOptional<IItemHandler> lazyHandler;

        public OreBagProvider(@Nullable CompoundTag nbt) {
            if (nbt != null) {
                this.handler.deserializeNBT(nbt);
            } else {
                ChemistryMod.LOGGER.debug("OreBag NBT was null, creating new tag.");
            }
            this.lazyHandler = LazyOptional.of(() -> this.handler);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == ForgeCapabilities.ITEM_HANDLER ? this.lazyHandler.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.handler.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.handler.deserializeNBT(nbt);
        }

        private static boolean isAcceptableItem(ItemStack stack) {
            return stack.m_204117_(ChemiTags.Items.ORE_BAG_ACCEPT);
        }
    }
}

