/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.item.bioreagent;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.item.bioreagent.BioProperties;
import kandango.reagenica.item.bioreagent.BioReagent;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BioGrowingPlate
extends BioReagent {
    private static final String PARENT_TYPE = "ParentType";
    private static final String PARENT_SPEED_KEY = "ParentEfficiency";
    private static final String PARENT_VITALITY = "ParentVitality";
    private static final String STERILE_KEY = "Sterile";
    private static final String GROWTH = "Growth";

    public BioGrowingPlate(BioProperties prop) {
        super(prop);
    }

    public static void setStats(ItemStack stack, String parent, int parentVitality, int speed, boolean sterile) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(PARENT_TYPE, parent);
        tag.m_128405_(PARENT_VITALITY, parentVitality);
        tag.m_128405_(PARENT_SPEED_KEY, speed);
        tag.m_128379_(STERILE_KEY, sterile);
    }

    public static void setGrowth(ItemStack stack, int growth) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(GROWTH, growth);
        stack.m_41721_(320 - growth * 40);
    }

    @Override
    public int getSpeed(ItemStack stack) {
        return this.getOrDefault(stack, PARENT_SPEED_KEY, 0);
    }

    @Override
    public boolean isSterile(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(STERILE_KEY) && tag.m_128471_(STERILE_KEY);
    }

    public String parentType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? (tag.m_128441_(PARENT_TYPE) ? tag.m_128461_(PARENT_TYPE) : "") : "";
    }

    public int getGrowth(ItemStack stack) {
        return this.getOrDefault(stack, GROWTH, 0);
    }

    @Override
    public int getColor(ItemStack stack) {
        if (this.props.color() == 0) {
            return this.getOrDefault(stack, "Color", 0xFFFFFFFF & (0x1000000 << this.getGrowth(stack) | 0xFFFFFF));
        }
        return this.props.color() & (0x1000000 << this.getGrowth(stack) | 0xFFFFFF);
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        this.superAppendHoverText(stack, level, tooltip, flag);
        if (!this.parentType(stack).isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)this.typeToTranslatable(this.parentType(stack))).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237110_((String)"tooltip.reagenica.plate_growth", (Object[])new Object[]{this.getGrowth(stack)}).m_130940_(ChatFormatting.GRAY));
        if (this.isSterile(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.reagenica.sterile").m_130940_(ChatFormatting.GREEN));
        }
    }

    private String typeToTranslatable(String name) {
        Objects.requireNonNull(name);
        if (name.equals("Crude")) {
            return "tooltip.reagenica.crude";
        }
        if (name.equals("Yeast")) {
            return "tooltip.reagenica.yeast";
        }
        if (name.equals("Oryzae")) {
            return "tooltip.reagenica.oryzae";
        }
        if (name.equals("Acetobacter")) {
            return "tooltip.reagenica.acetobacter";
        }
        return "tooltip.reagenica.unknown";
    }

    public static ItemStack getPlate(String name, int speed, boolean sterile) {
        ItemStack stack = new ItemStack((ItemLike)ChemiItems.GROWING_PLATE.get());
        BioGrowingPlate.setStats(stack, name, 320, speed, sterile);
        stack.m_41721_(320);
        return stack;
    }

    public static ItemStack getPlateFromParent(ItemStack plate, ItemStack parent) {
        Item sterile2;
        Item item;
        ItemStack stack = new ItemStack((ItemLike)ChemiItems.GROWING_PLATE.get());
        if (plate.m_41720_() == ChemiItems.MEDIUM_PLATE.get() && (item = parent.m_41720_()) instanceof BioReagent) {
            BioReagent bio = (BioReagent)item;
            boolean sterile2 = bio.isSterile(plate);
            String parentType = parent.m_41720_() == ChemiItems.YEAST.get() ? "Yeast" : (parent.m_41720_() == ChemiItems.ORYZAE.get() ? "Oryzae" : (parent.m_41720_() == ChemiItems.ACETOBACTER.get() ? "Acetobacter" : "Unknown"));
            int parentSpeed = bio.getSpeed(parent);
            int parentVitality = 320 - bio.getDamage(parent);
            BioGrowingPlate.setStats(stack, parentType, parentVitality, parentSpeed, sterile2);
        } else if (plate.m_41720_() == ChemiItems.MEDIUM_PLATE.get() && (sterile2 = plate.m_41720_()) instanceof BioReagent) {
            BioReagent bio = (BioReagent)sterile2;
            boolean sterile3 = bio.isSterile(plate);
            BioGrowingPlate.setStats(stack, "Crude", 320, 0, sterile3);
        } else {
            throw new IllegalArgumentException("Given ItemStacks was not valid plates.");
        }
        stack.m_41721_(320);
        return stack;
    }
}

