/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.item.bioreagent;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.item.bioreagent.BioProperties;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BioReagent
extends Item {
    private static final String SPEED_KEY = "Efficiency";
    private static final String STERILE_KEY = "Sterile";
    protected static final String COLOR_KEY = "Color";
    protected final BioProperties props;

    public BioReagent(BioProperties prop) {
        super(new Item.Properties().m_41487_(1).m_41503_(320));
        this.props = prop;
    }

    public BioReagent(BioProperties prop, int stackcount) {
        super(new Item.Properties().m_41487_(stackcount));
        this.props = prop;
    }

    public int getColor(ItemStack stack) {
        if (this.props.color() == 0) {
            return this.getOrDefault(stack, COLOR_KEY, -1);
        }
        return this.props.color();
    }

    protected int getOrDefault(ItemStack stack, String key, int def) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(key) ? tag.m_128451_(key) : def;
    }

    public static void setStats(ItemStack stack, int speed, boolean sterile) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(SPEED_KEY, speed);
        tag.m_128379_(STERILE_KEY, sterile);
    }

    public static void setColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(COLOR_KEY, color);
    }

    public int getSpeed(ItemStack stack) {
        return this.getOrDefault(stack, SPEED_KEY, 0);
    }

    public boolean isSterile(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(STERILE_KEY) && tag.m_128471_(STERILE_KEY);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (!this.props.scientific_name().isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)this.props.scientific_name()).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_41720_() != ChemiItems.CONTAMINATED_PLATE.get()) {
            tooltip.add((Component)Component.m_237113_((String)("Efficiency: " + this.getSpeed(stack))).m_130940_(ChatFormatting.GRAY));
        }
        if (this.isSterile(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.reagenica.sterile").m_130940_(ChatFormatting.GREEN));
        }
    }

    protected void superAppendHoverText(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
    }
}

