/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.item.reagent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.item.reagent.GasReagent;
import kandango.reagenica.item.reagent.LiquidReagent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ReagentFluidMap {
    public static Map<Fluid, Item> fluidItemMap = new HashMap<Fluid, Item>();
    public static Map<Item, Fluid> itemFluidMap = new HashMap<Item, Fluid>();

    public static void register(@Nonnull Fluid fluid, @Nonnull Item continerItem) {
        if (fluidItemMap.containsKey(fluid)) {
            throw new IllegalArgumentException("dupricate fluid map registry: " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)continerItem)));
        }
        fluidItemMap.put(fluid, continerItem);
        itemFluidMap.put(continerItem, fluid);
    }

    public static void registerAll(List<RegistryObject<? extends Item>> itemlist) {
        for (RegistryObject<? extends Item> itemobj : itemlist) {
            Item item = (Item)itemobj.get();
            if (item instanceof LiquidReagent) {
                LiquidReagent reagent = (LiquidReagent)item;
                reagent.getRelativeFluid().ifPresent(x -> ReagentFluidMap.register(x, reagent));
                continue;
            }
            if (!(item instanceof GasReagent)) continue;
            GasReagent reagent = (GasReagent)item;
            reagent.getRelativeFluid().ifPresent(x -> ReagentFluidMap.register(x, reagent));
        }
    }

    public static void printMap() {
        ChemistryMod.LOGGER.debug("=== Fluid <-> Item Map Contents ===");
        for (Map.Entry<Fluid, Item> entry : fluidItemMap.entrySet()) {
            Fluid fluid = entry.getKey();
            Item item = entry.getValue();
            ResourceLocation fluidId = ForgeRegistries.FLUIDS.getKey((Object)fluid);
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
            String fluidName = fluidId != null ? fluidId.toString() : "unknown_fluid";
            String itemName = itemId != null ? itemId.toString() : "unknown_item";
            ChemistryMod.LOGGER.debug("Fluid {} = Item {}", (Object)fluidName, (Object)itemName);
        }
    }

    public static Optional<Item> getItemfromFluid(Fluid fluid) {
        return Optional.ofNullable(fluidItemMap.get(fluid));
    }

    public static Optional<Fluid> getFluidfromItem(Item item) {
        return Optional.ofNullable(itemFluidMap.get(item));
    }
}

