/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.jei.AnalyzerCategory;
import kandango.reagenica.jei.BlastFurnaceCategory;
import kandango.reagenica.jei.CookingCategory;
import kandango.reagenica.jei.CrusherCategory;
import kandango.reagenica.jei.DissolverCategory;
import kandango.reagenica.jei.ElectroLysisCategory;
import kandango.reagenica.jei.FermentingCategory;
import kandango.reagenica.jei.FractionalDistillerCategory;
import kandango.reagenica.jei.HeatFurnaceCategory;
import kandango.reagenica.jei.JEIPluginRecipes;
import kandango.reagenica.jei.ReactorCategory;
import kandango.reagenica.jei.ReagentMixingCategory;
import kandango.reagenica.jei.TradingCategory;
import kandango.reagenica.recipes.AnalyzerRecipe;
import kandango.reagenica.recipes.BlastFurnaceRecipe;
import kandango.reagenica.recipes.CookingRecipe;
import kandango.reagenica.recipes.CrusherRecipe;
import kandango.reagenica.recipes.DissolverRecipe;
import kandango.reagenica.recipes.ElectroLysisRecipe;
import kandango.reagenica.recipes.FermentationRecipe;
import kandango.reagenica.recipes.FractionalDistillerRecipe;
import kandango.reagenica.recipes.HeatFurnaceRecipe;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.recipes.ReactorRecipe;
import kandango.reagenica.recipes.ReagentMixingRecipe;
import kandango.reagenica.recipes.StallTradingRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ChemistryJEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("reagenica", "jei_plugin");
    private static List<JEIPluginRecipes<? extends Container, ? extends Recipe<?>>> pluginrecipes = List.of(new JEIPluginRecipes("reagent_mixing", ReagentMixingRecipe.class, ModRecipes.REAGENT_MIXING_TYPE, helper -> new ReagentMixingCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.EXPERIMENT_BLOCK.get())), new JEIPluginRecipes("fermentation", FermentationRecipe.class, ModRecipes.FERMENTATION_TYPE, helper -> new FermentingCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.CHEMICAL_FERMENTER.get())), new JEIPluginRecipes("blast_furnace", BlastFurnaceRecipe.class, ModRecipes.BLAST_FURNACE_TYPE, helper -> new BlastFurnaceCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.BLASTFURNACE_BOTTOM.get())), new JEIPluginRecipes("heat_furnace", HeatFurnaceRecipe.class, ModRecipes.HEAT_FURNACE_TYPE, helper -> new HeatFurnaceCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.HEAT_FURNACE.get())), new JEIPluginRecipes("distilling", FractionalDistillerRecipe.class, ModRecipes.DISTILLING_TYPE, helper -> new FractionalDistillerCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.FRACTIONAL_DISTILLER_BOTTOM.get())), new JEIPluginRecipes("electrolysis", ElectroLysisRecipe.class, ModRecipes.ELECTROLYSIS_TYPE, helper -> new ElectroLysisCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.ELECTROLYSIS_DEVICE.get())), new JEIPluginRecipes("analyzer", AnalyzerRecipe.class, ModRecipes.ANALYZER_TYPE, helper -> new AnalyzerCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.ANALYZER.get())), new JEIPluginRecipes("crusher", CrusherRecipe.class, ModRecipes.CRUSHER_TYPE, helper -> new CrusherCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.CRUSHER.get())), new JEIPluginRecipes("dissolver", DissolverRecipe.class, ModRecipes.DISSSOLVER_TYPE, helper -> new DissolverCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.DISSOLVER.get())), new JEIPluginRecipes("reactor", ReactorRecipe.class, ModRecipes.REACTOR_TYPE, helper -> new ReactorCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.REACTOR.get())), new JEIPluginRecipes("cooking", CookingRecipe.class, ModRecipes.COOKING_TYPE, helper -> new CookingCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.COOKING_POT.get())), new JEIPluginRecipes("trading", StallTradingRecipe.class, ModRecipes.STALL_TRADING_TYPE, helper -> new TradingCategory((IJeiHelpers)helper), () -> new ItemStack((ItemLike)ChemiBlocks.TRADING_STALL.get())));

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration reg) {
        for (JEIPluginRecipes<? extends Container, ? extends Recipe<?>> jEIPluginRecipes : pluginrecipes) {
            reg.addRecipeCategories(new IRecipeCategory[]{jEIPluginRecipes.category.apply(reg.getJeiHelpers())});
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration reg) {
        Minecraft mc = Minecraft.m_91087_();
        Objects.requireNonNull(mc.f_91073_, "Ancient NullPointer Attack!!");
        RecipeManager recipeManager = mc.f_91073_.m_7465_();
        for (JEIPluginRecipes<? extends Container, ? extends Recipe<?>> jEIPluginRecipes : pluginrecipes) {
            this.registerRecipeHelper(reg, recipeManager, jEIPluginRecipes);
        }
    }

    private <C extends Container, T extends Recipe<C>> void registerRecipeHelper(IRecipeRegistration reg, RecipeManager manager, JEIPluginRecipes<C, T> def) {
        reg.addRecipes(def.jeirecipetype, def.getAllRecipes(manager));
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration reg) {
        for (JEIPluginRecipes<? extends Container, ? extends Recipe<?>> jEIPluginRecipes : pluginrecipes) {
            reg.addRecipeCatalyst(jEIPluginRecipes.catalyst.get(), new RecipeType[]{jEIPluginRecipes.jeirecipetype});
        }
    }
}

