/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.block.fluid.ChemiFluidBurnMap;
import kandango.reagenica.block.fluid.ChemiFluidBurnrate;
import kandango.reagenica.item.reagent.ReagentFluidMap;
import kandango.reagenica.jei.AirSeparationCategory;
import kandango.reagenica.jei.FluidBurningCategory;
import kandango.reagenica.jei.FluidDrainingCategory;
import kandango.reagenica.jei.FluidFillingCategory;
import kandango.reagenica.jei.HaberBoschCategory;
import kandango.reagenica.jei.IncubatorCategory;
import kandango.reagenica.recipes.AirSeparationRecipe;
import kandango.reagenica.recipes.FluidBurningRecipe;
import kandango.reagenica.recipes.FluidDrainingRecipe;
import kandango.reagenica.recipes.FluidFillingRecipe;
import kandango.reagenica.recipes.HaberBoschRecipe;
import kandango.reagenica.recipes.IncubatorRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class ChemistryJEIPluginInternal
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("reagenica", "jei_plugin_internal");

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidFillingCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidDrainingCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidBurningCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new HaberBoschCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AirSeparationCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubatorCategory(registration.getJeiHelpers())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ItemStack output;
        FluidStack input;
        List<Record> recipes = new ArrayList<Record>();
        for (Map.Entry<Fluid, Item> entry : ReagentFluidMap.fluidItemMap.entrySet()) {
            input = new FluidStack(entry.getKey(), 100);
            output = new ItemStack((ItemLike)entry.getValue());
            recipes.add(new FluidFillingRecipe(input, output));
        }
        registration.addRecipes(FluidFillingCategory.TYPE, recipes);
        recipes = new ArrayList();
        for (Map.Entry<Fluid, Item> entry : ReagentFluidMap.itemFluidMap.entrySet()) {
            input = new ItemStack((ItemLike)entry.getKey());
            output = new FluidStack((Fluid)entry.getValue(), 100);
            recipes.add(new FluidDrainingRecipe((ItemStack)input, (FluidStack)output));
        }
        registration.addRecipes(FluidDrainingCategory.TYPE, recipes);
        recipes = new ArrayList();
        for (Map.Entry<Fluid, Object> entry : ChemiFluidBurnMap.fluidBurnMap.entrySet()) {
            input = new FluidStack(entry.getKey(), 1000);
            ChemiFluidBurnrate rate = (ChemiFluidBurnrate)entry.getValue();
            recipes.add(new FluidBurningRecipe(input, rate.burnTick(), rate.energyPerTick()));
        }
        registration.addRecipes(FluidBurningCategory.TYPE, recipes);
        recipes = new ArrayList();
        recipes.add(new HaberBoschRecipe(new FluidStack(ChemiFluids.NITROGEN.getFluid(), 50), new FluidStack(ChemiFluids.HYDROGEN.getFluid(), 150), new FluidStack(ChemiFluids.AMMONIA.getFluid(), 100)));
        registration.addRecipes(HaberBoschCategory.TYPE, recipes);
        recipes = new ArrayList();
        recipes.add(new AirSeparationRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ChemiItems.COPPER_FILTER.get()), new ItemStack((ItemLike)ChemiItems.SILVER_FILTER.get()), new ItemStack((ItemLike)ChemiItems.PLATINUM_FILTER.get())}), new FluidStack(ChemiFluids.NITROGEN.getFluid(), 80), new FluidStack(ChemiFluids.OXYGEN.getFluid(), 20)));
        registration.addRecipes(AirSeparationCategory.TYPE, recipes);
        recipes = IncubatorRecipe.getRecipes();
        registration.addRecipes(IncubatorCategory.TYPE, recipes);
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ChemiBlocks.COPPER_TANK.get()), new RecipeType[]{FluidFillingCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ChemiBlocks.COPPER_TANK.get()), new RecipeType[]{FluidDrainingCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ChemiBlocks.FLUID_FUEL_GENERATOR.get()), new RecipeType[]{FluidBurningCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ChemiBlocks.HABER_BOSCH.get()), new RecipeType[]{HaberBoschCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ChemiBlocks.AIR_SEPARATOR.get()), new RecipeType[]{AirSeparationCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ChemiBlocks.INCUBATOR.get()), new RecipeType[]{IncubatorCategory.TYPE});
    }
}

