/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.recipes.DissolverRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DissolverCategory
implements IRecipeCategory<DissolverRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reagenica", "dissolver");
    private final IDrawable background;
    private final IDrawable icon;

    public DissolverCategory(IJeiHelpers helpers) {
        this.background = helpers.getGuiHelper().createDrawable(new ResourceLocation("reagenica", "textures/gui/container/dissolver.png"), 0, 0, 176, 80);
        this.icon = helpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ChemiBlocks.DISSOLVER.get()));
    }

    public RecipeType<DissolverRecipe> getRecipeType() {
        return RecipeType.create((String)"reagenica", (String)"dissolver", DissolverRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.reagenica.dissolver");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull DissolverRecipe recipe, @Nonnull IFocusGroup fg) {
        builder.addSlot(RecipeIngredientRole.INPUT, 70, 29).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 63).addItemStack(recipe.getOutputItem());
        if (!recipe.getInputFluid().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 44, 30).addFluidStack(recipe.getInputFluid().getFluid(), (long)recipe.getInputFluid().getAmount())).setFluidRenderer(1000L, false, 16, 48);
        }
        if (!recipe.getResultFluid().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 30).addFluidStack(recipe.getResultFluid().getFluid(), (long)recipe.getResultFluid().getAmount())).setFluidRenderer(1000L, false, 16, 48);
        }
    }
}

