/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.recipes.FluidBurningRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FluidBurningCategory
implements IRecipeCategory<FluidBurningRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reagenica", "fluid_burning");
    public static final RecipeType<FluidBurningRecipe> TYPE = RecipeType.create((String)"reagenica", (String)"fluid_burning", FluidBurningRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FluidBurningCategory(IJeiHelpers helpers) {
        this.background = helpers.getGuiHelper().createDrawable(new ResourceLocation("reagenica", "textures/gui/container/fluid_fuel_generator.png"), 0, 0, 176, 82);
        this.icon = helpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ChemiBlocks.FLUID_FUEL_GENERATOR.get()));
    }

    public RecipeType<FluidBurningRecipe> getRecipeType() {
        return RecipeType.create((String)"reagenica", (String)"fluid_burning", FluidBurningRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.reagenica.fluid_burning");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull FluidBurningRecipe recipe, @Nonnull IFocusGroup fg) {
        if (!recipe.in().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 44, 23).addFluidStack(recipe.in().getFluid(), (long)recipe.in().getAmount())).setFluidRenderer(4000L, false, 16, 48);
        }
    }

    public void draw(@Nonnull FluidBurningRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.reagenica.burn_tick", (Object[])new Object[]{recipe.tick()}), 104, 57, -15658735, false);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.reagenica.burn_energy", (Object[])new Object[]{recipe.ept()}), 104, 67, -15658735, false);
    }
}

