/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.recipes.FractionalDistillerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FractionalDistillerCategory
implements IRecipeCategory<FractionalDistillerRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reagenica", "distilling");
    private final IDrawable background;
    private final IDrawable icon;

    public FractionalDistillerCategory(IJeiHelpers helpers) {
        this.background = helpers.getGuiHelper().createDrawable(new ResourceLocation("reagenica", "textures/gui/container/fractional_distiller.png"), 0, 0, 176, 122);
        this.icon = helpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ChemiBlocks.FRACTIONAL_DISTILLER_BOTTOM.get()));
    }

    public RecipeType<FractionalDistillerRecipe> getRecipeType() {
        return RecipeType.create((String)"reagenica", (String)"distilling", FractionalDistillerRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.reagenica.distilling");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull FractionalDistillerRecipe recipe, @Nonnull IFocusGroup fg) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 101).addItemStack(recipe.getResidual());
        if (!recipe.getInput().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 8, 39).addFluidStack(recipe.getInput().getFluid(), (long)recipe.getInput().getAmount())).setFluidRenderer(400L, false, 16, 48);
        }
        if (!recipe.getBottom().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 129, 70).addFluidStack(recipe.getBottom().getFluid(), (long)recipe.getBottom().getAmount())).setFluidRenderer(400L, false, 16, 48);
        }
        if (!recipe.getTop().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 129, 9).addFluidStack(recipe.getTop().getFluid(), (long)recipe.getTop().getAmount())).setFluidRenderer(400L, false, 16, 48);
        }
    }
}

