/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.recipes.HeatFurnaceRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HeatFurnaceCategory
implements IRecipeCategory<HeatFurnaceRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reagenica", "heat_furnace");
    private final IDrawable background;
    private final IDrawable icon;

    public HeatFurnaceCategory(IJeiHelpers helpers) {
        this.background = helpers.getGuiHelper().createDrawable(new ResourceLocation("reagenica", "textures/gui/container/heat_furnace.png"), 0, 0, 176, 80);
        this.icon = helpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ChemiBlocks.HEAT_FURNACE.get()));
    }

    public RecipeType<HeatFurnaceRecipe> getRecipeType() {
        return RecipeType.create((String)"reagenica", (String)"heat_furnace", HeatFurnaceRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.reagenica.heat_furnace");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull HeatFurnaceRecipe recipe, @Nonnull IFocusGroup fg) {
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 23).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 24).addItemStack(recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 48).addItemStack(recipe.getByproduct());
        if (!recipe.getInputFluid().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 30).addFluidStack(recipe.getInputFluid().getFluid(), (long)recipe.getInputFluid().getAmount())).setFluidRenderer(400L, false, 16, 48);
        }
        if (!recipe.getResultFluid().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 135, 30).addFluidStack(recipe.getResultFluid().getFluid(), (long)recipe.getResultFluid().getAmount())).setFluidRenderer(400L, false, 16, 48);
        }
    }
}

