/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.recipes.ReactorRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ReactorCategory
implements IRecipeCategory<ReactorRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reagenica", "reactor");
    private final IDrawable background;
    private final IDrawable icon;

    public ReactorCategory(IJeiHelpers helpers) {
        this.background = helpers.getGuiHelper().createDrawable(new ResourceLocation("reagenica", "textures/gui/container/reactor_jei.png"), 0, 0, 176, 120);
        this.icon = helpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ChemiBlocks.ELECTROLYSIS_DEVICE.get()));
    }

    public RecipeType<ReactorRecipe> getRecipeType() {
        return RecipeType.create((String)"reagenica", (String)"reactor", ReactorRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.reagenica.reactor");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull ReactorRecipe recipe, @Nonnull IFocusGroup fg) {
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 76).addIngredients(recipe.getInput());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 63, 58).addItemStack(new ItemStack((ItemLike)ChemiItems.URANIUM_FUEL_ROD.get()))).addTooltipCallback((view, tooltip) -> tooltip.add(Component.m_237115_((String)"tooltip.reagenica.jei_fuelrod")));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 76).addItemStack(recipe.getOutput());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 56, 40).addFluidStack(ChemiFluids.DISTILLED_WATER.getFluid(), 30000L)).setFluidRenderer(30000L, false, 64, 72);
    }
}

