/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiBlocks;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.client.ClientRenderUtil;
import kandango.reagenica.recipes.ReagentMixingRecipe;
import kandango.reagenica.recipes.items.IngredientWithCount;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ReagentMixingCategory
implements IRecipeCategory<ReagentMixingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reagenica", "reagent_mixing");
    private final IDrawable background;
    private final IDrawable icon;

    public ReagentMixingCategory(IJeiHelpers helpers) {
        this.background = helpers.getGuiHelper().createDrawable(new ResourceLocation("reagenica", "textures/gui/container/experiment_block.png"), 0, 0, 176, 85);
        this.icon = helpers.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ChemiBlocks.EXPERIMENT_BLOCK.get()));
    }

    public RecipeType<ReagentMixingRecipe> getRecipeType() {
        return RecipeType.create((String)"reagenica", (String)"reagent_mixing", ReagentMixingRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.reagenica.reagent_mixing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull ReagentMixingRecipe recipe, @Nonnull IFocusGroup fg) {
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            IngredientWithCount ic = recipe.getInputs().get(i);
            ArrayList<ItemStack> listitems = new ArrayList<ItemStack>();
            for (int j = 0; j < ic.getIngredient().m_43908_().length; ++j) {
                listitems.add(ic.toItemStack(j));
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 56, i == 0 ? 17 : 53).addItemStacks(listitems);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 97, 55).addIngredients(recipe.getCatalyst());
        builder.addSlot(RecipeIngredientRole.INPUT, 79, 55).addItemStacks(recipe.isHeatRequired() ? List.of(new ItemStack((ItemLike)ChemiItems.ALCHOHOL_LAMP.get()), new ItemStack((ItemLike)ChemiItems.EASY_TORCH.get())) : List.of());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 149, 14).addItemStack(recipe.getOutputA());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 149, 32).addItemStack(recipe.getOutputB());
    }

    public void draw(@Nonnull ReagentMixingRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ResourceLocation TEXTURE = new ResourceLocation("reagenica", "textures/gui/container/experiment_block.png");
        if (recipe.isHeatRequired()) {
            ClientRenderUtil.renderFireAtDefaultposInGui(TEXTURE, guiGraphics, 0, 0, 1, 1, 79, 39);
            if (mouseX >= 79.0 && mouseX <= 93.0 && mouseY >= 40.0 && mouseY <= 53.0) {
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"Heating Required"), (int)mouseX, (int)mouseY);
            }
        }
    }
}

