/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.network;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.network.BroadcastUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class CableNetworkManager {
    private static final Map<ResourceKey<Level>, Set<BlockPos>> pendingUpdates = new ConcurrentHashMap<ResourceKey<Level>, Set<BlockPos>>();

    public static void requestUpdate(@Nonnull ServerLevel slv, BlockPos pos) {
        pendingUpdates.computeIfAbsent((ResourceKey<Level>)slv.m_46472_(), r -> ConcurrentHashMap.newKeySet()).add(pos);
    }

    public static void tick(@Nonnull ServerLevel slv) {
        if (pendingUpdates.isEmpty()) {
            return;
        }
        ResourceKey currentDim = slv.m_46472_();
        Set<BlockPos> positions = pendingUpdates.get(currentDim);
        if (positions != null && !positions.isEmpty()) {
            for (BlockPos pos : positions) {
                if (!slv.m_46749_(pos)) continue;
                int count = BroadcastUtil.broadcastChange(pos, slv);
                ChemistryMod.LOGGER.debug("Broadcasted from {}, notified to {} BEs.", (Object)pos.m_123344_(), (Object)count);
            }
        }
        pendingUpdates.remove(currentDim);
    }
}

