/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.packet;

import java.util.function.Supplier;
import kandango.reagenica.packet.IDualTankBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class SyncDualFluidTanksPacket {
    private final BlockPos pos;
    private final FluidStack fluid1;
    private final FluidStack fluid2;

    public SyncDualFluidTanksPacket(BlockPos pos, FluidStack fluid1, FluidStack fluid2) {
        this.pos = pos;
        this.fluid1 = fluid1;
        this.fluid2 = fluid2;
    }

    public static void encode(SyncDualFluidTanksPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        msg.fluid1.writeToPacket(buf);
        msg.fluid2.writeToPacket(buf);
    }

    public static SyncDualFluidTanksPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        FluidStack fluid1 = FluidStack.readFromPacket((FriendlyByteBuf)buf);
        FluidStack fluid2 = FluidStack.readFromPacket((FriendlyByteBuf)buf);
        return new SyncDualFluidTanksPacket(pos, fluid1, fluid2);
    }

    public static void handle(SyncDualFluidTanksPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity patt1420$temp;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && (patt1420$temp = mc.f_91073_.m_7702_(msg.pos)) instanceof IDualTankBlock) {
                IDualTankBlock be = (IDualTankBlock)patt1420$temp;
                be.receivePacket(msg.fluid1, msg.fluid2);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

