/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.AnalyzerRecipe;
import kandango.reagenica.recipes.RecipeJsonHelper;
import kandango.reagenica.recipes.items.ItemStackWithChance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AnalyzerRecipeSerializer
implements RecipeSerializer<AnalyzerRecipe> {
    public AnalyzerRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
        Ingredient input = RecipeJsonHelper.ingredientFromJsonRequired(json, "input");
        ItemStack return_item = RecipeJsonHelper.itemStackFromJsonifPresent(json, "return_item");
        List<ItemStackWithChance> results = RecipeJsonHelper.listFromJson(json, "results", js -> ItemStackWithChance.fromJson(js));
        return new AnalyzerRecipe(id, input, results, return_item);
    }

    public AnalyzerRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int resultcount = buf.readInt();
        ArrayList<ItemStackWithChance> stacks = new ArrayList<ItemStackWithChance>();
        for (int i = 0; i < resultcount; ++i) {
            stacks.add(ItemStackWithChance.fromFriendlyBuf(buf));
        }
        ItemStack returnitem = buf.m_130267_();
        return new AnalyzerRecipe(id, input, stacks, returnitem);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull AnalyzerRecipe recipe) {
        recipe.getInput().m_43923_(buf);
        List<ItemStackWithChance> stacks = recipe.getResults();
        buf.writeInt(stacks.size());
        stacks.stream().forEach(ic -> ItemStackWithChance.toFriendlyBuf(buf, ic));
        buf.writeItemStack(recipe.getReturnItem(), false);
    }
}

