/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.BlastFurnaceRecipe;
import kandango.reagenica.recipes.RecipeJsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class BlastFurnaceRecipeSerializer
implements RecipeSerializer<BlastFurnaceRecipe> {
    public BlastFurnaceRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
        Ingredient input = RecipeJsonHelper.ingredientFromJsonRequired(json, "input");
        ItemStack result = RecipeJsonHelper.itemStackFromJsonRequired(json, "result");
        ItemStack byproduct = RecipeJsonHelper.itemStackFromJsonifPresent(json, "byproduct");
        int minTemp = RecipeJsonHelper.intFromJson(json, "temp_min");
        int maxTemp = RecipeJsonHelper.intFromJson(json, "temp_max");
        float exp = RecipeJsonHelper.floatFromJson(json, "exp");
        return new BlastFurnaceRecipe(id, input, result, byproduct, minTemp, maxTemp, exp);
    }

    public BlastFurnaceRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        ItemStack result = buf.m_130267_();
        ItemStack byproduct = buf.m_130267_();
        int minTemp = buf.readInt();
        int maxTemp = buf.readInt();
        float exp = buf.readFloat();
        return new BlastFurnaceRecipe(id, input, result, byproduct, minTemp, maxTemp, exp);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull BlastFurnaceRecipe recipe) {
        recipe.getInput().m_43923_(buf);
        buf.writeItemStack(recipe.getOutput(), false);
        buf.writeItemStack(recipe.getByproduct(), false);
        buf.writeInt(recipe.getMinTemp());
        buf.writeInt(recipe.getMaxTemp());
        buf.writeFloat(recipe.getExp());
    }
}

