/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.CookingRecipe;
import kandango.reagenica.recipes.RecipeJsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CookingRecipeSerializer
implements RecipeSerializer<CookingRecipe> {
    public CookingRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
        List<Ingredient> inputs = RecipeJsonHelper.listFromJson(json, "inputs", j -> Ingredient.m_43917_((JsonElement)j));
        ItemStack result = RecipeJsonHelper.itemStackFromJsonRequired(json, "result");
        return new CookingRecipe(id, inputs, result);
    }

    public CookingRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
        List<Ingredient> inputs = RecipeJsonHelper.listIngredientFromFrientlyBuf(buf);
        ItemStack result = buf.m_130267_();
        return new CookingRecipe(id, inputs, result);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull CookingRecipe recipe) {
        RecipeJsonHelper.sendIngredientList(buf, recipe.getInputs());
        buf.writeItemStack(recipe.getOutput(), false);
    }
}

