/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.recipes.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class DissolverRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final FluidStack fluidIn;
    private final FluidStack fluidOut;
    private final ItemStack output;

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getFluidIn() {
        return this.fluidIn;
    }

    public FluidStack getFluidOut() {
        return this.fluidOut;
    }

    public ItemStack getOutputItem() {
        return this.output;
    }

    public DissolverRecipe(ResourceLocation id, Ingredient i, FluidStack fin, FluidStack fout, ItemStack out) {
        this.id = id;
        this.input = i;
        this.fluidIn = fin;
        this.fluidOut = fout;
        this.output = out;
    }

    public boolean m_5818_(@Nonnull Container container, @Nonnull Level level) {
        return this.input.test(container.m_8020_(0));
    }

    private boolean matchest(ItemStack item, FluidStack fluid) {
        return this.input.test(item) && FluidStackUtil.isEnoughFluid(fluid, this.fluidIn);
    }

    public static Optional<DissolverRecipe> getRecipe(@Nonnull FluidStack fluidstack, ItemStack item, @Nonnull Level level) {
        List recipes = level.m_7465_().m_44013_((RecipeType)ModRecipes.DISSSOLVER_TYPE.get());
        return recipes.stream().filter(r -> r.matchest(item, fluidstack)).findFirst();
    }

    public FluidStack getResultFluid() {
        return this.fluidOut.copy();
    }

    public FluidStack getInputFluid() {
        return this.fluidIn.copy();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@Nonnull RegistryAccess access) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.DISSOLVER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.DISSSOLVER_TYPE.get();
    }

    public ItemStack m_5874_(@Nonnull Container p_44001_, @Nonnull RegistryAccess p_267165_) {
        return this.output;
    }
}

