/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.DissolverRecipe;
import kandango.reagenica.recipes.RecipeJsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

public class DissolverRecipeSerializer
implements RecipeSerializer<DissolverRecipe> {
    public DissolverRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
        Ingredient input = RecipeJsonHelper.ingredientFromJsonRequired(json, "input");
        FluidStack influid = RecipeJsonHelper.fluidStackFromJsonifPresent(json, "influid");
        FluidStack outfluid = RecipeJsonHelper.fluidStackFromJsonifPresent(json, "outfluid");
        ItemStack outitem = RecipeJsonHelper.itemStackFromJsonifPresent(json, "itemresult");
        return new DissolverRecipe(id, input, influid, outfluid, outitem);
    }

    public DissolverRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        FluidStack influid = RecipeJsonHelper.fluidStackFromFriendlyBuf(buf);
        FluidStack outfluid = RecipeJsonHelper.fluidStackFromFriendlyBuf(buf);
        ItemStack outitem = buf.m_130267_();
        return new DissolverRecipe(id, input, influid, outfluid, outitem);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull DissolverRecipe recipe) {
        recipe.getInput().m_43923_(buf);
        RecipeJsonHelper.sendFluidStack(buf, recipe.getFluidIn());
        RecipeJsonHelper.sendFluidStack(buf, recipe.getFluidOut());
        buf.writeItemStack(recipe.getOutputItem(), false);
    }
}

