/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.recipes.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class ElectroLysisRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final FluidStack fluid;
    private final Ingredient electrodeN;
    private final Ingredient electrodeP;
    private final FluidStack generatedfluid;
    private final ItemStack outputn;
    private final ItemStack outputp;
    private final ItemStack outputgasn;
    private final ItemStack outputgasp;
    private final boolean anodeMelt;

    public FluidStack getFluidIn() {
        return this.fluid;
    }

    public Ingredient getElectrodeN() {
        return this.electrodeN;
    }

    public Ingredient getElectrodeP() {
        return this.electrodeP;
    }

    public FluidStack getFluidOut() {
        return this.generatedfluid;
    }

    public ItemStack getOutputN() {
        return this.outputn;
    }

    public ItemStack getOutputP() {
        return this.outputp;
    }

    public ItemStack getOutputGasN() {
        return this.outputgasn;
    }

    public ItemStack getOutputGasP() {
        return this.outputgasp;
    }

    public boolean anodeMelts() {
        return this.anodeMelt;
    }

    public ElectroLysisRecipe(ResourceLocation id, FluidStack in, Ingredient en, Ingredient ep, FluidStack gen, ItemStack on, ItemStack op, ItemStack ogn, ItemStack ogp, boolean am) {
        this.id = id;
        this.fluid = in;
        this.electrodeN = en;
        this.electrodeP = ep;
        this.generatedfluid = gen;
        this.outputn = on;
        this.outputp = op;
        this.outputgasn = ogn;
        this.outputgasp = ogp;
        this.anodeMelt = am;
    }

    public boolean m_5818_(@Nonnull Container container, @Nonnull Level level) {
        ItemStack en = container.m_8020_(1);
        ItemStack ep = container.m_8020_(2);
        return this.isValidElectrode(this.electrodeN, en, true) && this.isValidElectrode(this.electrodeP, ep, true);
    }

    public boolean matchest(@Nonnull FluidStack fluid, ItemStack en, ItemStack ep, boolean strict) {
        boolean fl = FluidStackUtil.isEnoughFluid(fluid, this.fluid);
        boolean ers = this.isValidElectrode(this.electrodeN, en, strict) && this.isValidElectrode(this.electrodeP, ep, strict);
        return fl && ers;
    }

    public static Optional<ElectroLysisRecipe> getRecipe(@Nonnull FluidStack fluidstack, ItemStack en, ItemStack ep, @Nonnull Level level) {
        List recipes = level.m_7465_().m_44013_((RecipeType)ModRecipes.ELECTROLYSIS_TYPE.get());
        return recipes.stream().filter(r -> r.matchest(fluidstack, en, ep, true)).findFirst().or(() -> recipes.stream().filter(r -> r.matchest(fluidstack, en, ep, false)).findFirst());
    }

    private boolean isValidElectrode(Ingredient electrode, ItemStack stack, boolean strict) {
        if (electrode.m_43908_().length != 1) {
            return !strict && electrode.test(stack);
        }
        return electrode.test(stack);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@Nonnull RegistryAccess access) {
        return this.outputn;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ELECTROLYSIS_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.ELECTROLYSIS_TYPE.get();
    }

    public ItemStack m_5874_(@Nonnull Container p_44001_, @Nonnull RegistryAccess p_267165_) {
        return this.outputn.m_41777_();
    }
}

