/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.block.entity.util.FluidStackUtil;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.recipes.RecipeHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FermentationRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final List<Ingredient> inputs;
    private final FluidStack inputFluid;
    private final FluidStack output;
    private final ItemStack outputitem;
    private final Ingredient bioseed;

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public ItemStack getOutputItem() {
        return this.outputitem;
    }

    public Ingredient getBioseed() {
        return this.bioseed;
    }

    public FermentationRecipe(ResourceLocation id, List<Ingredient> i, FluidStack in, FluidStack o, ItemStack io, Ingredient ca) {
        this.id = id;
        this.inputs = i;
        this.inputFluid = in;
        this.output = o;
        this.outputitem = io;
        this.bioseed = ca;
    }

    public boolean m_5818_(@Nonnull Container container, @Nonnull Level level) {
        return false;
    }

    private boolean matchest(@Nonnull Container container, FluidStack fluid) {
        if (!RecipeHelper.isAllMeets(container, this.inputs)) {
            return false;
        }
        if (!this.bioseed.test(container.m_8020_(4))) {
            return false;
        }
        return FluidStackUtil.isEnoughFluid(fluid, this.inputFluid);
    }

    public static Optional<FermentationRecipe> getRecipe(@Nonnull Container container, FluidStack fluid, @Nonnull Level lv) {
        List recipes = lv.m_7465_().m_44013_((RecipeType)ModRecipes.FERMENTATION_TYPE.get());
        return recipes.stream().filter(r -> r.matchest(container, fluid)).findFirst();
    }

    public FluidStack getResultFluid() {
        return this.output.copy();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@Nonnull RegistryAccess access) {
        return this.outputitem;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.FERMENTATION_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.FERMENTATION_TYPE.get();
    }

    public ItemStack m_5874_(@Nonnull Container p_44001_, @Nonnull RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }
}

