/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonSyntaxException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.recipes.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ReagenimartRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack merchandise;
    private final ItemStack price;
    private final ReagenimartCategory category;
    private final int order;

    public ItemStack getMerchandise() {
        return this.merchandise;
    }

    public ItemStack getPrice() {
        return this.price;
    }

    public ReagenimartCategory getCategory() {
        return this.category;
    }

    public int getOrder() {
        return this.order;
    }

    public ReagenimartRecipe(ResourceLocation id, ItemStack m, ItemStack p, String cat, int ord) {
        this.id = id;
        this.merchandise = m;
        this.price = p;
        this.category = this.tocat(cat);
        this.order = ord;
    }

    public ReagenimartRecipe(ResourceLocation id, ItemStack m, ItemStack p, int cat, int ord) {
        this.id = id;
        this.merchandise = m;
        this.price = p;
        this.category = ReagenimartCategory.values()[cat];
        this.order = ord;
    }

    public boolean m_5818_(@Nonnull Container container, @Nonnull Level level) {
        return ItemStackUtil.isEnough(container.m_8020_(0), this.merchandise);
    }

    public boolean isValidPayment(@Nonnull ItemStack stack) {
        return ItemStackUtil.isEnough(stack, this.price);
    }

    public static List<ReagenimartRecipe> getAllRecipe(@Nonnull Level lv) {
        return lv.m_7465_().m_44013_((RecipeType)ModRecipes.REAGENIMART_TYPE.get());
    }

    public static List<ReagenimartRecipe> getRecipeCategorized(@Nonnull Level lv, ReagenimartCategory cat) {
        return ReagenimartRecipe.getAllRecipe(lv).stream().filter(r -> r.getCategory().equals((Object)cat)).sorted(Comparator.comparingInt(r -> r.order).thenComparing(r -> r.id.toString())).toList();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@Nonnull RegistryAccess access) {
        return this.price;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.REAGENIMART_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.REAGENIMART_TYPE.get();
    }

    public ItemStack m_5874_(@Nonnull Container p_44001_, @Nonnull RegistryAccess p_267165_) {
        return this.price.m_41777_();
    }

    private ReagenimartCategory tocat(String key) {
        switch (key) {
            case "building": {
                return ReagenimartCategory.BUILDING;
            }
            case "commodity": {
                return ReagenimartCategory.COMMODITY;
            }
            case "minerals": {
                return ReagenimartCategory.MINERALS;
            }
            case "naturals": {
                return ReagenimartCategory.NATURALS;
            }
        }
        throw new JsonSyntaxException("[" + key + "] is not valid category");
    }

    public static enum ReagenimartCategory {
        BUILDING,
        COMMODITY,
        MINERALS,
        NATURALS;

    }
}

