/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.ReagenimartRecipe;
import kandango.reagenica.recipes.RecipeJsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ReagenimartRecipeSerializer
implements RecipeSerializer<ReagenimartRecipe> {
    public ReagenimartRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
        ItemStack merchandise = RecipeJsonHelper.itemStackFromJsonRequired(json, "merchandise");
        ItemStack price = RecipeJsonHelper.itemStackFromJsonRequired(json, "price");
        String type = RecipeJsonHelper.stringFromJson(json, "category").orElseThrow(() -> new JsonSyntaxException("category is required"));
        int order = RecipeJsonHelper.intFromJsonOptional(json, "order").orElse(10);
        return new ReagenimartRecipe(id, merchandise, price, type, order);
    }

    public ReagenimartRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
        ItemStack merchandise = buf.m_130267_();
        ItemStack price = buf.m_130267_();
        int cat = buf.m_130242_();
        int order = buf.m_130242_();
        return new ReagenimartRecipe(id, merchandise, price, cat, order);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull ReagenimartRecipe recipe) {
        buf.writeItemStack(recipe.getMerchandise(), false);
        buf.writeItemStack(recipe.getPrice(), false);
        buf.m_130130_(recipe.getCategory().ordinal());
        buf.m_130130_(recipe.getOrder());
    }
}

