/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.item.burnable.HeatProvidingItem;
import kandango.reagenica.recipes.ModRecipes;
import kandango.reagenica.recipes.items.IngredientWithCount;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ReagentMixingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final List<IngredientWithCount> inputs;
    private final ItemStack outputA;
    private final ItemStack outputB;
    private final Ingredient catalyst;
    private final boolean isHeatRequired;

    public List<IngredientWithCount> getInputs() {
        return this.inputs;
    }

    public ItemStack getOutputA() {
        return this.outputA;
    }

    public ItemStack getOutputB() {
        return this.outputB;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public boolean isHeatRequired() {
        return this.isHeatRequired;
    }

    public ReagentMixingRecipe(ResourceLocation id, List<IngredientWithCount> ings, ItemStack oA, ItemStack oB, Ingredient ca, boolean heat) {
        this.id = id;
        this.inputs = ings;
        this.outputA = oA;
        this.outputB = oB;
        this.catalyst = ca;
        this.isHeatRequired = heat;
    }

    public boolean m_5818_(@Nonnull Container container, @Nonnull Level level) {
        boolean inputreagent = true;
        for (IngredientWithCount ic : this.inputs) {
            boolean flag = false;
            for (int i = 0; i < 2; ++i) {
                flag |= ic.test(container.m_8020_(i));
            }
            if (flag) continue;
            return false;
        }
        ItemStack flame = container.m_8020_(2);
        boolean heatExists = !this.isHeatRequired || flame.m_41720_() instanceof HeatProvidingItem && flame.m_41773_() < flame.m_41776_();
        boolean catalyst = this.catalyst == Ingredient.f_43901_ || this.catalyst.test(container.m_8020_(3));
        return inputreagent && heatExists && catalyst;
    }

    public static Optional<ReagentMixingRecipe> getRecipe(@Nonnull Container container, @Nonnull Level lv) {
        List recipes = lv.m_7465_().m_44013_((RecipeType)ModRecipes.REAGENT_MIXING_TYPE.get());
        return recipes.stream().filter(r -> r.m_5818_(container, lv)).max(Comparator.comparingInt(r -> r.priority()));
    }

    private int priority() {
        int input = this.inputs.size();
        boolean heat = this.isHeatRequired;
        boolean cat = !this.catalyst.m_43947_();
        return input * 4 + (cat ? 2 : 0) + (heat ? 1 : 0);
    }

    public ItemStack m_5874_(@Nonnull Container container, @Nonnull RegistryAccess rg) {
        return this.outputA.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@Nonnull RegistryAccess access) {
        return this.outputA;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.REAGENT_MIXING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.REAGENT_MIXING_TYPE.get();
    }
}

