/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.ReagentMixingRecipe;
import kandango.reagenica.recipes.RecipeJsonHelper;
import kandango.reagenica.recipes.items.IngredientWithCount;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ReagentMixingRecipeSerializer
implements RecipeSerializer<ReagentMixingRecipe> {
    public ReagentMixingRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
        List<IngredientWithCount> inputs = RecipeJsonHelper.listFromJson(json, "inputs", j -> IngredientWithCount.fromJson(j));
        ItemStack resultA = RecipeJsonHelper.itemStackFromJsonRequired(json, "result_a");
        ItemStack resultB = RecipeJsonHelper.itemStackFromJsonifPresent(json, "result_b");
        Ingredient catalyst = RecipeJsonHelper.ingredientFromJsonifPresent(json, "catalyst");
        boolean heat = GsonHelper.m_13855_((JsonObject)json, (String)"requires_heat", (boolean)false);
        return new ReagentMixingRecipe(id, inputs, resultA, resultB, catalyst, heat);
    }

    public ReagentMixingRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
        List<IngredientWithCount> inputs = RecipeJsonHelper.listFromFriendlyBuf(buf, b -> IngredientWithCount.fromFriendlyBuf(b));
        ItemStack resultA = buf.m_130267_();
        ItemStack resultB = buf.m_130267_();
        Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buf);
        boolean heat = buf.readBoolean();
        return new ReagentMixingRecipe(id, inputs, resultA, resultB, catalyst, heat);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull ReagentMixingRecipe recipe) {
        RecipeJsonHelper.sendList(buf, recipe.getInputs(), (b, l) -> IngredientWithCount.toFriendlyBuf(b, l));
        buf.writeItemStack(recipe.getOutputA(), false);
        buf.writeItemStack(recipe.getOutputB(), false);
        recipe.getCatalyst().m_43923_(buf);
        buf.writeBoolean(recipe.isHeatRequired());
    }
}

