/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeJsonHelper {
    public static FluidStack fluidStackFromJson(@Nonnull JsonObject json, String name) {
        JsonObject resultfluidObj = json.getAsJsonObject(name);
        int amount = resultfluidObj.get("amount").getAsInt();
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        String fluidId = resultfluidObj.get("fluid").getAsString();
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidId));
        if (fluid == null) {
            throw new JsonSyntaxException("Invalid fluid id: '" + fluidId + "' in '" + name + "'");
        }
        FluidStack result = new FluidStack(fluid, amount);
        return result;
    }

    public static FluidStack fluidStackFromJsonifPresent(@Nonnull JsonObject json, String name) {
        return json.has(name) ? RecipeJsonHelper.fluidStackFromJson(json, name) : FluidStack.EMPTY;
    }

    public static FluidStack fluidStackFromJsonRequired(@Nonnull JsonObject json, String name) {
        if (json.has(name)) {
            return RecipeJsonHelper.fluidStackFromJson(json, name);
        }
        throw new JsonSyntaxException("Fluid " + name + " is required");
    }

    public static ItemStack itemStackFromJsonifPresent(@Nonnull JsonObject json, String name) {
        return json.has(name) ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)name)) : ItemStack.f_41583_;
    }

    public static ItemStack itemStackFromJsonRequired(@Nonnull JsonObject json, String name) {
        if (!json.has(name)) {
            throw new JsonSyntaxException("Itemstack " + name + " is required");
        }
        return ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)name));
    }

    public static Ingredient ingredientFromJsonifPresent(@Nonnull JsonObject json, String name) {
        return json.has(name) ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)name)) : Ingredient.f_43901_;
    }

    public static Ingredient ingredientFromJsonRequired(@Nonnull JsonObject json, String name) {
        if (!json.has(name)) {
            throw new JsonSyntaxException("Ingredient " + name + " is required");
        }
        return Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)name));
    }

    public static int intFromJson(@Nonnull JsonObject json, String name) {
        if (!json.has(name)) {
            throw new JsonSyntaxException("Integer " + name + " is required");
        }
        return json.get(name).getAsInt();
    }

    public static Optional<Integer> intFromJsonOptional(@Nonnull JsonObject json, String name) {
        return Optional.ofNullable(json.get(name)).map(j -> j.getAsInt());
    }

    public static Optional<String> stringFromJson(@Nonnull JsonObject json, String name) {
        return Optional.ofNullable(json.get(name)).map(j -> j.getAsString());
    }

    public static float floatFromJson(@Nonnull JsonObject json, String name) {
        if (!json.has(name)) {
            throw new JsonSyntaxException("Float " + name + " is required");
        }
        return json.get(name).getAsFloat();
    }

    public static <T> List<T> listFromJson(@Nonnull JsonObject json, String name, Function<JsonObject, T> reader) {
        if (!json.has(name)) {
            throw new JsonSyntaxException("Itemstacks " + name + " is required");
        }
        JsonArray itemsArray = GsonHelper.m_13933_((JsonObject)json, (String)name);
        ArrayList<T> items = new ArrayList<T>();
        for (JsonElement elem : itemsArray) {
            JsonObject obj = elem.getAsJsonObject();
            items.add(reader.apply(obj));
        }
        return items;
    }

    public static FluidStack fluidStackFromFriendlyBuf(@Nonnull FriendlyByteBuf buf) {
        ResourceLocation fluidId = new ResourceLocation(buf.m_130277_());
        int amount = buf.readInt();
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        return new FluidStack(fluid, amount);
    }

    public static void sendFluidStack(@Nonnull FriendlyByteBuf buf, @Nonnull FluidStack fluid) {
        buf.m_130070_(ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid()).toString());
        buf.writeInt(fluid.getAmount());
    }

    public static List<Ingredient> listIngredientFromFrientlyBuf(@Nonnull FriendlyByteBuf buf) {
        int count = buf.m_130242_();
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (int i = 0; i < count; ++i) {
            list.add(Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        return list;
    }

    public static void sendIngredientList(@Nonnull FriendlyByteBuf buf, @Nonnull List<? extends Ingredient> list) {
        buf.m_130130_(list.size());
        for (Ingredient ingredient : list) {
            ingredient.m_43923_(buf);
        }
    }

    public static <T> List<T> listFromFriendlyBuf(@Nonnull FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader) {
        int count = buf.m_130242_();
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            list.add(reader.apply(buf));
        }
        return list;
    }

    public static <T> void sendList(@Nonnull FriendlyByteBuf buf, @Nonnull List<T> list, BiConsumer<FriendlyByteBuf, T> writer) {
        buf.m_130130_(list.size());
        for (T item : list) {
            writer.accept(buf, (FriendlyByteBuf)item);
        }
    }
}

