/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.recipes.RecipeJsonHelper;
import kandango.reagenica.recipes.StallTradingRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class StallTradingRecipeSerializer
implements RecipeSerializer<StallTradingRecipe> {
    public StallTradingRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
        ItemStack merchandise = RecipeJsonHelper.itemStackFromJsonRequired(json, "merchandise");
        ItemStack price = RecipeJsonHelper.itemStackFromJsonRequired(json, "price");
        if (merchandise.m_41613_() == 0) {
            throw new JsonSyntaxException("Invalid Recipe: merchandise count is 0 in " + id.toString());
        }
        if (merchandise.m_41613_() < price.m_41613_() && merchandise.m_41741_() / merchandise.m_41613_() * price.m_41613_() > 64) {
            ChemistryMod.LOGGER.warn("The price item may overflow in the recipe {}", (Object)id.toString());
        }
        return new StallTradingRecipe(id, merchandise, price);
    }

    public StallTradingRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
        ItemStack merchandise = buf.m_130267_();
        ItemStack price = buf.m_130267_();
        return new StallTradingRecipe(id, merchandise, price);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull StallTradingRecipe recipe) {
        buf.writeItemStack(recipe.getMerchandise(), false);
        buf.writeItemStack(recipe.getPrice(), false);
    }
}

