/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.RecipeJsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class IngredientWithCount {
    private final Ingredient ingredient;
    private final int count;

    public IngredientWithCount(Ingredient ing, int count) {
        this.ingredient = ing;
        this.count = count;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack) && stack.m_41613_() >= this.count;
    }

    public ItemStack toItemStack(int index) {
        return new ItemStack((ItemLike)this.ingredient.m_43908_()[index].m_41720_(), this.count);
    }

    public static IngredientWithCount fromJson(@Nonnull JsonObject json) {
        Ingredient item = Ingredient.m_43917_((JsonElement)json);
        int count = RecipeJsonHelper.intFromJsonOptional(json, "count").orElse(1);
        return new IngredientWithCount(item, count);
    }

    public static IngredientWithCount fromFriendlyBuf(@Nonnull FriendlyByteBuf buf) {
        Ingredient stack = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int count = buf.m_130242_();
        return new IngredientWithCount(stack, count);
    }

    public static void toFriendlyBuf(@Nonnull FriendlyByteBuf buf, IngredientWithCount ingcount) {
        ingcount.ingredient.m_43923_(buf);
        buf.m_130130_(ingcount.count);
    }
}

