/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.recipes.items;

import com.google.gson.JsonObject;
import java.util.Random;
import javax.annotation.Nonnull;
import kandango.reagenica.recipes.RecipeJsonHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class ItemStackWithChance {
    private final ItemStack stack;
    private final float chance;

    public ItemStackWithChance(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public ItemStack get() {
        return this.stack;
    }

    public ItemStack roll(Random rand) {
        float random = rand.nextFloat();
        return random < this.chance ? this.stack : ItemStack.f_41583_;
    }

    public float getChance() {
        return this.chance;
    }

    public static ItemStackWithChance fromJson(@Nonnull JsonObject json) {
        ItemStack stack = ShapedRecipe.m_151274_((JsonObject)json);
        float chance = RecipeJsonHelper.floatFromJson(json, "chance");
        return new ItemStackWithChance(stack, chance);
    }

    public static ItemStackWithChance fromFriendlyBuf(@Nonnull FriendlyByteBuf buf) {
        ItemStack stack = buf.m_130267_();
        float chance = buf.readFloat();
        return new ItemStackWithChance(stack, chance);
    }

    public static void toFriendlyBuf(@Nonnull FriendlyByteBuf buf, ItemStackWithChance stackchance) {
        buf.writeItemStack(stackchance.stack, false);
        buf.writeFloat(stackchance.chance);
    }
}

